#include "mbed.h"
#include "functions.h"
#include "ble_functions.h"

#include "RawSerial.h"
#include "bmi160.h"
#include "max32630fthr.h"
#include "max3263x.h"
#include "MAX14690.h"
#include "Adafruit_SSD1306.h"
#include "MAX30100_PulseOximeter.h"
#include "mlx90614.h"

#include <BLE.h>
#include "ble/BLE.h"
#include "ble/Gap.h"

#include "SDBlockDevice.h"
#include "FATFileSystem.h"

#include <errno.h>
#include <stdio.h>
#include <time.h>
#include <stdint.h>
#include <InterruptIn.h>
#include <InterruptManager.h>

//MAX32630FTHR
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

//MAX14690 Wearable Power-Management Solution Driver
I2C i2cm2(I2C2_SDA, I2C2_SCL);
MAX14690 max14690(&i2cm2);

char device_id[10];

Mutex stdio_mutex;

int sensor_temp = 1;
unsigned short int measure_id = 0;
unsigned short int log_id = 0;

//SD-Karte
FATFileSystem   fileSystem("fs");
SDBlockDevice   blockDevice(P0_5, P0_6, P0_4, P0_7);  // mosi, miso, sck, cs

//Bluetooth-Modul PAN1326B
RawSerial pan1326b(P0_1, P0_0); //TX, RX
DigitalOut bt_rst (P1_6);        //Bluetooth reset

//I2C
I2C i2c(P3_4, P3_5); //SDA, SCL

//Akku
AnalogIn battery(AIN_0);

//LED
DigitalOut r (P2_4);
DigitalOut g (P2_5);
DigitalOut b (P2_6);
DigitalOut RGBs[] = {r, g, b}; // r, g, b
 
//Button interrupt
InterruptIn button(P2_3, PullUp);

//I2C OLED
Adafruit_SSD1306_I2c featherOLED(i2c);

//OLED
InterruptIn aButton(P5_3, PullUp);
InterruptIn bButton(P3_3, PullUp);
InterruptIn cButton(P3_2, PullUp);

AnalogIn ain0(AIN_4); 
AnalogIn ain1(AIN_5); 
AnalogIn ain2(AIN_2); 
AnalogIn ain3(AIN_3);

//MAX30100
Timer t;
PulseOximeter pox;
uint32_t tsLastReport = 0;

//PulseSensor
/*
PulseSensor* sensor;
static volatile uint8_t hrmCounter;
static volatile bool triggerSensorPolling;
*/

AnalogIn ain = AIN_4;
double anSignal;
int bpm;
int signal;
int ibi;

//MLX90614
MLX90614 IR_thermometer(&i2c);
float ir_temp; //temperature in degrees C

float           buffer_temp;
struct          tm current = {0};
struct          tm actual = {0};

//char ble_buff[255];
int counter_ble = 0;

Timeout after_BLE;
Timeout led_check;                  //Zum Überprüfen, ob Datenlogger an ist
Timeout turnoff;                    //Zum Auschalten (nicht implementiert)
Timeout flipper;                    //Zum Bluetooth an / aus
Timeout advertise_cancel;           //Zum abbrechen von BT bei keinem Verbindungsaufbau
Timeout connected_cancel;           //Zum abbrechen von BT bei kein Befehlempfang
Ticker mess_timer;                  //ticker eventuell nur bis 30 Minuten geeignet
Ticker ticker;
Ticker hearth;

time_t now;
time_t raw;

volatile int quit = 0;
volatile int ble_return = 0;
volatile int conn_state = 0;        //Verbindungsstatus für BLE

bool after_BT = false;
bool in_BT = false;                 //Flag für BLE ist an
bool error_status = false;          //Wenn es ein Fehler beim Initialisierung gab
bool BT_error = false;              //Wenn es BLE oder SD Fehler ist, dann werden die Button Interrupts nicht deklariert
bool shipping = false;              //Sendevorgang Status
bool pause = true;                  //Pause während Sendevorgang
bool init_status = false;           //Erfolgreiche Initialisierung Status
bool charge = false;                //Wenn DL an Stromnetz angeschlossen ist

struct tm user_config_time;
struct user_config_struct user_config_para = {0, 0, 0, 0, 0, 0, 0};

int next_state = 0;                 // State-Machine

int unsigned long t_diff = 0;
int unsigned long unix_time = 0;

int default_advertise_time = 300;
int default_connected_time = 180;

int alert_count = 0;

float heartRate;
uint8_t sp02;

void turnOFF(){
    flipper.detach();
    turnoff.detach();
    printf("\nTEST 2\n");
    char string[] = "Shutting down Coldchainlogger...";
    write_to_sd_log_single(string);
    printf("\nTEST 3\n");
    printf("\n__________________________\n\nColdcahinlogger - OFF\n__________________________\n\n");
    wait(0.2);
    
    max14690.shutdown();
}

void flip(){
    in_BT = !in_BT;
    if(in_BT == true){
        BT_true();
    }else if(in_BT == false){
        BT_false();
    }
}

void onCheck(){
    g = 1;
    r = 1;
}

void pushed() 
{
    flipper.attach(&flip, 1);     // Button für eine Sekunde gedrückt halten um BT zu aktivieren
    turnoff.attach(&turnOFF, 5);     // Button für eine Sekunde gedrückt halten um BT zu aktivieren
}

void released() {
    if(quit == 0 && charge == false && after_BT == false){
        g = 0;
        led_check.attach(&onCheck, 3);
    }
    flipper.detach();
    turnoff.detach();
}

void mess_handler(){
    next_state = 3;
}

void states(){
    switch(next_state){
        case 0:
        {
            mess_timer.detach();
            printf("No Finger\n");
            while ( next_state == 0 ){
                loop();
                if(battery.read() > 0.95){
                    r = 0;
                    g = 0;
                    charge = true;
                }else{
                    r = 1;
                    charge = false;
                }
                loop();
                featherOLED.display();
                featherOLED.clearDisplay();
                featherOLED.setTextCursor(0,0);
                featherOLED.printf("No Finger");
                featherOLED.display();
            }
            break;
        }
        case 1:
        {
            mess_timer.attach(&mess_handler, (float)user_config_para.interval);
            while ( next_state == 1 ){
                loop();
                featherOLED.display();
                featherOLED.clearDisplay();
                featherOLED.setTextCursor(0,0);
                featherOLED.printf("Heart rate: %f\n",heartRate);
                featherOLED.printf("SpO2: %d%\r\n",sp02);
                featherOLED.display();
            }
            break;
        }
        case 2:
        {
            conn_state = 0;
            quit = 1;
            BLE_handler();
            break;
        }
        case 3:
        {
            get_Messwert();
            next_state = 1;
            break;
        }
    }
}

int main() {
    init();
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    if(BT_error == true){
        printf("\nBluetooth or SD initialize error: bluetooth can not be used\n");
    }else{
        __enable_irq();
        button.fall(&pushed);
        button.rise(&released);
    }
    while(true) {
        states();
    }
}