#ifndef DOUBLELINKEDLIST_H
#define DOUBLELINKEDLIST_H

typedef struct llnode_t {
    void* data;
    struct llnode_t* previous;
    struct llnode_t* next;
} LLNode;

typedef struct dlinkedlist_t {
    struct llnode_t* head;
    struct llnode_t* tail;
    struct llnode_t* current;
    int size;
} DLinkedList;


/* A function pointer type for functions that take in void* and return nothing
 * Such a function may be useful for doing something to modify the data
 * The name of this type is "ddl_op"
 */
typedef void (*dll_op)(void*);

/* A function pointer type for functions that take in two const void* and return an int
 * Such a function may be useful for comparing data
 * The name of this type is "ddl_comp"
 */
typedef int (*dll_comp)(const void*, const void*);

/********************************************
 * Doublely Linked List library functions *
 * For more details on their functionality, *
 * see the documentation in doublelyLinkedList.c *
 ********************************************/
LLNode* create_llnode(void* data);
DLinkedList* create_dlinkedlist(void);
void insertHead(DLinkedList* dLinkedList, void* data);
void insertTail(DLinkedList* dLinkedList, void* data);
int insertAfter(DLinkedList* dLinkedList, void* newData);
int insertBefore(DLinkedList* dLinkedList, void* newData);
void* deleteBackward(DLinkedList* dLinkedList, dll_op free_func);
void* deleteForward(DLinkedList* dLinkedList, dll_op free_func);
void traverseList(DLinkedList* dLinkedList, dll_op do_func);
void destroyList(DLinkedList* dLinkedList, dll_op free_func);
void* getHead(DLinkedList* dLinkedList);
void* getTail(DLinkedList* dLinkedList);
void* getCurrent(DLinkedList* dLinkedList);
void* getNext(DLinkedList* dLinkedList);
void* getPrevious(DLinkedList* dLinkedList);
int getSize(DLinkedList* dLinkedList);
#endif
