#include "mbed.h"

#define KEYCODE 0xAA
#define TX_CHECKCODE (tx_data[1]^tx_data[2]^tx_data[3]^tx_data[4]^tx_data[5]^tx_data[6]^tx_data[7]^tx_data[8]^tx_data[9]^tx_data[10])
#define RX_CHECKCODE (rx_data[1]^rx_data[2]^rx_data[3]^rx_data[4]^rx_data[5]^rx_data[6]^rx_data[7]^rx_data[8]^rx_data[9]^rx_data[10])
#define DATA_NUM 12
#define CHECK (DATA_NUM - 1)
#define ALL_IR 10



extern Serial sensor;
extern Serial pc;
extern unsigned int hangar[ALL_IR];

void micon_rx(){
    
    static uint8_t rx;
    static uint8_t rx_data[DATA_NUM];
    
    rx_data[rx] = sensor.getc();
    
    if(rx_data[0] == KEYCODE){
        rx++;
    }
    
    if(rx >= DATA_NUM){
        if(rx_data[CHECK] == RX_CHECKCODE){
             pc.printf("%d %d %d %d %d\n", rx_data[1], rx_data[2], rx_data[3], rx_data[4], rx_data[5]);
        }  
     rx = 0;   
    }

}

void micon_tx(){
    
    static uint8_t tx;
    static uint8_t tx_data[DATA_NUM];
    
    if(tx >= DATA_NUM){
        tx_data[0] = KEYCODE;
        tx_data[1] = hangar[0];
        tx_data[2] = hangar[1];
        tx_data[3] = hangar[2];
        tx_data[4] = hangar[3];
        tx_data[5] = hangar[4];
        tx_data[6] = hangar[5];
        tx_data[7] = hangar[6];
        tx_data[8] = hangar[7];
        tx_data[9] = hangar[8];
        tx_data[10] = hangar[9];
        tx_data[11] = TX_CHECKCODE;
        
        tx = 0;
    }
    
    sensor.putc(tx_data[tx]);
    //pc.printf("%d\n", tx_data[tx]);
    tx++;
    //wait(0.1);
}