#include "mbed.h"
#include "common.h"

#define KEYCODE 0xAA
#define TX_CHECKCODE (tx_data[1]^tx_data[2]^tx_data[3]^tx_data[4]^tx_data[5]^tx_data[6]^tx_data[7]^tx_data[8])
#define RX_CHECKCODE (rx_data[1]^rx_data[2]^rx_data[3]^rx_data[4]^rx_data[5]^rx_data[6]^rx_data[7]^rx_data[8])
#define DATA_NUM 11
#define CHECK (DATA_NUM - 1)
#define ALL_IR 11


extern Serial xbee;
extern Serial sensor;
extern Serial pc;
extern DigitalOut myled[4];

extern uint8_t value_ir, ir_num, ir_dis, ball_on;
extern uint8_t ping[4];
extern uint8_t line[4];
extern uint8_t ir_max, ir_num;
extern int compass;

int count = 0;
void xbee_tx(){
    xbee.putc(1);
}

void xbee_rx(){
    if(xbee.readable()){
        count = xbee.getc();
    } else {
        count = 0;
    }
    //pc.printf("%d\n", count);
}

void micon_rx(){
    
    static uint8_t rx;
    static int rx_data[DATA_NUM];
    
    rx_data[rx] = sensor.getc();
    
    if(rx_data[0] == KEYCODE){
        rx++;
    }
    
    if(rx >= DATA_NUM){
        if(rx_data[CHECK] == RX_CHECKCODE){
            value_ir = rx_data[1];
            ir_num = rx_data[2];
            ping[FRONT] = rx_data[3];
            ping[LEFT] = rx_data[4];
            ping[BACK] = rx_data[5];
            ping[RIGHT] = rx_data[6];
            compass = rx_data[7] + rx_data[8];
            ir_dis = rx_data[9];
            //ball_on = rx_data[10];
/*            line[FRONT] = rx_data[7];
            line[LEFT] = rx_data[8];
            line[BACK] = rx_data[9];
            line[RIGHT] = rx_data[10];
*/          
            //pc.printf("%d %d\n", rx_data[1], rx_data[2]); 
            //pc.printf("%d %d %d %d\n", rx_data[3], rx_data[4], rx_data[5], rx_data[6]);
            //pc.printf("%d %d %d %d\n", rx_data[7], rx_data[8], rx_data[9], rx_data[10]);
            //pc.printf("%d %d %d\n", rx_data[7], rx_data[8], compass);
            //pc.printf("%d\n", rx_data[7]);
            //pc.printf("%d\t%d\t%d\t%d\n", ping[FRONT], ping[LEFT], ping[BACK], ping[RIGHT]);
            //pc.printf("%d %d  %d\n", ping[LEFT], ping[RIGHT], ping[LEFT] + ping[RIGHT]);
            //pc.printf("%d\t%d\t%d\t%d\n", ir_dis, ball_on, value_ir, ir_num);
        }
     rx = 0;   
    }
    //pc.printf("%d\n", rx_data[rx]);
}

/*
void micon_tx(){
    
    static uint8_t tx;
    static uint8_t tx_data[DATA_NUM];
    
    if(tx >= DATA_NUM){
        tx_data[0] = KEYCODE;
        tx_data[1] = KEYCODE;
        tx_data[2] = KEYCODE;
        tx_data[3] = KEYCODE;
        tx_data[4] = KEYCODE;
        tx_data[5] = KEYCODE;
        tx_data[6] = KEYCODE;
        tx_data[7] = KEYCODE;
        tx_data[8] = KEYCODE;
        tx_data[9] = KEYCODE;
        tx_data[10] = KEYCODE;
        tx_data[11] = TX_CHECKCODE;
        
        tx = 0;
    }
    
    sensor.putc(tx_data[tx]);
    tx++;
}
*/