#include "mbed.h"
#include "QEI.h"
#include "TextLCD.h"

#define WHEEL   0
#define WHEEL_V 0.5     //left
#define WHEEL_VL 0.2    //right
#define FLAG_W  3

#define ROPE    1
#define ROPE_V0 0.18
#define ROPE_MAX    0.08
#define ROPE_V  0.05
#define ROPE_S  0.05
#define ROPE_L  0.001
#define FLAG_R  5

#define TYONPA_S    700
#define TYONPA_U    600
#define FLAG    5

Timer timer2;

extern double ultrasonicValue[4];
extern uint16_t ultrasonicVal[4];
extern void Ultrasonic(void);
extern void start_led(void);
extern double ave(int num, double value);


BusOut wheel(p9, p10, p11, p12);
BusOut rope(p13, p14);
BusOut legs(p15, p16);
BusOut rgbled(p17, p18, p19);
PwmOut pwm[4] = {p21, p22, p23, p24};
DigitalOut myled[4] = {LED1, LED2, LED3, LED4};
DigitalIn sw(p20);
//InterruptIn sw(p24);
QEI enc_l(p25, p26, NC, 360, QEI::X4_ENCODING);
QEI enc_r(p27, p28, NC, 360, QEI::X4_ENCODING);
QEI enc_p(p29, p30, NC, 360, QEI::X4_ENCODING);
//TextLCD lcd(p30, p29, p28, p27, p26, p25);

Ticker speeder;
Ticker pider;
Ticker pinger;

Timeout rope_steper;
Timeout rbleder;
Timeout waiter;
Timeout wheel_stoper;

Serial pc(USBTX, USBRX);