/***********************
*
*   This programme reads the values
*   from a sonar sensors and then prints
*   these to the onboard prototyping screen.
*
************************/

#include "mbed.h"
#include "ultrasonic.h"

#define SENREAD_SONAR_READINGSTORES_SIZE 20
#define SENREAD_SONAR_NUMBEROFSENSORS     3


const PinName SENPIN_SONAR_FCENTRE_TRIG = p24;
const PinName SENPIN_SONAR_FCENTRE_ECHO = p23;


Serial pc(USBTX, USBRX);


void SENFUNC_SONAR_FCENTRE(int distance);

 
 //Sensor Related
int SENREAD_SONAR_FCENTRE_READING = 1111;
int SENREAD_SONAR_FCENTRE_READERROR = 0;

int SENREAD_SONAR_MAXREADING = 1000;
int SENREAD_SONAR_MINREADING = 0;

int SENREAD_SONAR_MAXERROR = 5;
int SENREAD_SONAR_READERRORSTANDARD = 1111;

int SENREAD_SONAR_FCENTRE_READINGSTORE[SENREAD_SONAR_READINGSTORES_SIZE];
int SENREAD_SONAR_FCENTRE_READINGSTORE_POINTER = SENREAD_SONAR_READINGSTORES_SIZE - 1;

ultrasonic SENSOR_SONAR_FCENTRE(SENPIN_SONAR_FCENTRE_TRIG, SENPIN_SONAR_FCENTRE_ECHO, 0.5, 1, &SENFUNC_SONAR_FCENTRE); 


 void SENFUNC_SONAR_FCENTRE(int distance){
    //put code here to happen when the distance is changed
    SENREAD_SONAR_FCENTRE_READING = distance;
}


void printToScreen(){
    pc.printf("Value: %d\n\r", SENREAD_SONAR_FCENTRE_READING);
}

void updateQueue(int *store, int reading, int& element_pointer, int size){
        
    
    if(element_pointer < (size-1)){
        element_pointer++;
    }
    else{
        element_pointer = 0;
    }
    
    store[element_pointer] = reading;
}

int main() {

    wait(1.0);
    
    //Start the sensors
    SENSOR_SONAR_FCENTRE.startUpdates();
    pc.printf("Sonar Program Initialising\n\r");
    
    while(1) {

        SENSOR_SONAR_FCENTRE.checkDistance();
        updateQueue(SENREAD_SONAR_FCENTRE_READINGSTORE, SENREAD_SONAR_FCENTRE_READING, SENREAD_SONAR_FCENTRE_READINGSTORE_POINTER, SENREAD_SONAR_READINGSTORES_SIZE);
        printToScreen();
        wait(0.5);
        
    }
}
