#include "mbed.h"
#include "PololuLedStrip.h"

PololuLedStrip ledStrip(p13);

#define LED_COUNT 20
rgb_color colors[LED_COUNT];

Timer timer;

DigitalOut myled(LED1);

// Converts a color from the HSV representation to RGB.
rgb_color hsvToRgb(float h, float s, float v){
    int i = floor(h * 6);
    float f = h * 6 - i;
    float p = v * (1 - s);
    float q = v * (1 - f * s);
    float t = v * (1 - (1 - f) * s);
    float r = 0, g = 0, b = 0;
    switch(i % 6){
        case 0: r = v; g = t; b = p; break;
        case 1: r = q; g = v; b = p; break;
        case 2: r = p; g = v; b = t; break;
        case 3: r = p; g = q; b = v; break;
        case 4: r = t; g = p; b = v; break;
        case 5: r = v; g = p; b = q; break;
    }
    return (rgb_color){r * 255, g * 255, b * 255};
}

int main(){
    timer.start();

    myled = 1;
    
    while(1) {

            // Update the colors array.
    //        uint32_t time = timer.read_ms();   
        
            for(int i = 0; i < LED_COUNT; i++) {
                //uint8_t phase = (time >> 4) - (i << 2);
    //            colors[i] = hsvToRgb(phase / 256.0, 1.0, 1.0);
                colors[i] = (rgb_color){255, 0, 0};
            }
        
            // Send the colors to the LED strip.
            
            ledStrip.write(colors, LED_COUNT);
            wait(0.5);
    }
}
