#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "sansSerif19x20.h"
#include "DHT.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include  "HTTPClient.h"
#include "picojson.h"
#include "SDFileSystem.h" 
//IMPORTANT YOU NEED TO SET THE API KEY for thingspeak look for "your key here"
//TAKE CARE URL doesn't excced buffer size 
//sd card
 SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCLK, SSEL
//Ethernet Interface 
EthernetInterface eth;
//NTP service for date and Time used to set boards RTC
NTPClient ntp;
//HTTP Client for interfacing to web services
HTTPClient http;
char resp[1024]; //buffer for the responce
//On board LED
DigitalOut myled(LED_GREEN);
//serial over USB for debug and Info
Serial pc(USBTX, USBRX);
//temperature sensor
DHT sensor(PTB18,DHT22); // there are several libraries available, this reports CRC error sometimes 
//320x240 Display ILI9341 controller (look on ebay)
SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1,PTC3 ,PTC4 ,PTD0  ,"TFT"); // mosi, miso, sclk, cs, reset, dc

int main()
{
    int cnt = 0;
    int err;
    int ret=0;
    char val[4][16];
    //used to parse the json data
    picojson::value v;
    char * json;
    HTTPMap map;
    HTTPText inText(resp, 1024);
    char sdfile[32]; 
    FILE *fp;
    pc.printf("Weather Reporter\n");

    
    //eithernet init
    eth.init(); //Use DHCP
    ret= eth.connect();
     if (!ret) {
        pc.printf("Connected, IP: %s, MASK: %s, GW: %s\n",
        eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        pc.printf("Error eth.connect() - ret = %d\n", ret);
    }

 
    //setup the TFT DISPLAY
    TFT.claim(stdout);      // send stdout to the TFT display
    //ensure the output is write and not buffered
    setvbuf ( stdout , NULL , _IONBF , NULL );
    //TFT.claim(stderr);      // send stderr to the TFT display
    TFT.set_orientation(1);
    TFT.background(Black);    // set background to black
    //centerx = TFT.width() >> 1;
    //centery = TFT.height() >> 1; 
    

    TFT.cls();
    TFT.locate(0,0);
    TFT.set_font((unsigned char*) sansserif);
    //printf will now for to TFT because of the TFT.claim(stdout)
    printf("Weather Test\n"); 
   //setup the RTC with date and time 
    printf("Trying to update time...\r\n");
    time_t ctTime;
    NTPResult result;
    result = ntp.setTime("pool.ntp.org");
        if (result == NTP_OK) {
            time(&ctTime);
            printf("Time is set to (UTC):\n%s\n", ctime(&ctTime));
            strcpy(sdfile,"/sd/results/default_results"); //could use time in name
        }else{
            printf("Error setting Time\n");
            strcpy(sdfile,"/sd/results/default_results");
            }

    //write to sdcard, we could use the time and date in the filename defained above to give a new file for every session
    mkdir("/sd/results", 0777);
    fp = fopen(sdfile, "w");
        if (fp == NULL) {
        pc.printf("Unable to write the file \n");
        } else {
          pc.printf("Writing data to SDCARD \n");
         //time,temp,humidity,forcast,pressure
         fprintf(fp, "time,temperature,humidity,forcastTemp,forcastPressure\n");
         fclose(fp);
     }    
   
    float humidity=0;
    float temperature=-100;
    float forcastTemp=0;
    float forcastPressure;
    wait(10);
    pc.printf("\r\nDHT Test program");
    pc.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    while(1){
        
        //GET forcast data
        pc.printf("\nTrying to fetch page...\n");
        //try getting the weather, 5 second timeout     
        ret = http.get("http://api.openweathermap.org/data/2.5/weather?q=Strathaven,uk", resp, 5000);
        if(!ret){
          pc.printf("responce=%s",resp);
          json=&resp[0];    
          pc.printf("parsing");
          string err = picojson::parse(v, json, json + strlen(json));
          if(err.empty()){
           forcastTemp=v.get("main").get("temp").get<double>();
           forcastTemp=forcastTemp-273.15;
           forcastPressure=v.get("main").get("pressure").get<double>();
          // printf("Forcast temp: %f\n", forcastTemp);
          }
          else{
              pc.printf("error parsing");
         }    
       }
       else{
         pc.printf("ERROR=%d", ret);
      }    
        
    err = sensor.readData();
        if (err == 0) {
            TFT.cls();
            TFT.locate(0,0);
            time(&ctTime);
            printf("%s\n", ctime(&ctTime));
            temperature=sensor.ReadTemperature(CELCIUS);
            humidity=sensor.ReadHumidity();
            printf("Temperature:  %4.2f C \r\n",temperature);
            printf("Forcast Temp: %4.2f C \r\n",forcastTemp);  
            printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            printf("Humidity is %4.2f \r\n",humidity);
            printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            printf("Forcast Pressure: %4.2f C \r\n",forcastPressure);  
            myled = 1;
        } else{
            pc.printf("\r\nErr %i \n",err);
            myled = 0;
         }   
        
        
   //sent to thingsspeak
    if(cnt==10){ //don't update as often 
      cnt=0;  
      memset(resp, '\0', sizeof(resp));
    //POST data
      if(temperature!=-100){ //just check we have a valid temp
        map.put("api_key","YOUR KEY HERE");
        sprintf(val[0],"%4.1f",temperature);
        map.put("field1", val[0]);
        sprintf(val[1],"%4.1f",humidity);
        map.put("field2", val[1]);
        sprintf(val[2],"%4.1f",forcastTemp);
        map.put("field3", val[2]);
        sprintf(val[3],"%4.1f",forcastPressure); 
        map.put("field4", val[3]);
        pc.printf("\nTrying to post data...\n");
        ret = http.post("https://api.thingspeak.com/update", map, &inText);
        if (!ret)
        {
          pc.printf("Executed POST successfully - read %d characters\n", strlen(resp));
          pc.printf("Result: %s\n", resp);
        }
         else
        {
         pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
       //Write Data to SDCARD
        fp = fopen(sdfile, "a");
        if (fp == NULL) {
        pc.printf("Unable to write the file \n");
        } else {
          pc.printf("Writing data to SDCARD \n");
         //time,temp,humidity,forcast,pressure
         fprintf(fp, "%s,%4.1f,%4.1f,%4.1f,%4.1f\n", ctime(&ctTime),temperature,humidity,forcastTemp,forcastPressure);
         fclose(fp);
        } 
     }
     
    }
    
    cnt++;
    wait_ms(6000);
  }      
}
