#include "mbed.h"
#include "MotorDriver.h"
#include "math.h"
#include "Encoder.h"

Serial PC(USBTX,USBRX);
#define USBRX p14
#define USBTX p13


Encoder encoder(p16,p17);
MotorDriver Motor(p21,p19,p20); // Connect to pins PWM, INA, INB
AnalogIn senseB(p18);           //Connect to pin CS

int main(){

    PC.baud(115200);
    Motor.setEnabled(true);
    encoder.setEnabled(true);
    int i = 0;
  
    while(1)
    {
     Motor.setSpeed(sin(i/180.0*3.1415));
     PC.printf("%.3f\n\r",senseB.read());

     wait(5);
     PC.printf("%d\n\r",encoder.get_position());


     wait(5);
    }
 }