#include "mbed.h"
#include "ak8963.h"
#include "SerialNano.h"

#define PIN_SERIAL_TX   P0_4
#define PIN_SERIAL_RX   P0_5

#define I2C_SPEED_100KHZ    100000
#define I2C_SPEED_400KHZ    400000
 
int main() {
    // Initialize serial. This must be done before I2C initialization.
    SerialNano serial(PIN_SERIAL_TX, PIN_SERIAL_RX);
    serial.baud(115200);
    
    // Creates an instance of I2C
    I2C connection(I2C_SDA0, I2C_SCL0);
    connection.frequency(I2C_SPEED_100KHZ);

    // Creates an instance of AK8963
    AK8963 ak8963(&connection, AK8963::SLAVE_ADDR_1);
    
    // Checks connectivity
    if(ak8963.checkConnection() != AK8963::SUCCESS) {
        // Failed to check device connection.
        serial.printf("No device found.\n");
        return -1;
    }
    
    // Puts the device into continuous measurement mode.
    if(ak8963.setOperationMode(AK8963::MODE_CONTINUOUS_1) != AK8963::SUCCESS) {
        // Failed to set the device into continuous measurement mode.
        serial.printf("Failed to set device mode.\n");
        return -1;
    }

    AK8963::Status statusAK8963 = AK8963::NOT_DATA_READY;

    while(true) {
        // check DRDY
        statusAK8963 = ak8963.isDataReady();
        
        if (statusAK8963 == AK8963::DATA_READY) {
            AK8963::MagneticVector mag;
            ak8963.getMagneticVector(&mag);
            serial.printf("%d,%5.1f,%5.1f,%5.1f\r\n",
                mag.isOverflow,
                mag.mx, mag.my, mag.mz);
            statusAK8963 = AK8963::NOT_DATA_READY;
        } else if (statusAK8963 == AK8963::NOT_DATA_READY) {
            // Nothing to do.
        } else {
            // - error handling here -
        }
    }
}
