#include "mbed.h"
#include "LEDUtil.h"

#define PIN_HIGH  1
#define PIN_LOW   0

LEDUtil::LEDUtil(PinName targetPinName, LEDUtil::Polarity targetPinPolarity)
{
    this->pinName = targetPinName;
    this->polarity = targetPinPolarity;
}


void LEDUtil::setLedState(LedState state)
{
    DigitalOut pin(pinName);

    if (state == LEDUtil::LED_ON) {
        // turns on the LED
        pin.write((polarity == LEDUtil::HIGH_ON_LOW_OFF) ? PIN_HIGH : PIN_LOW);
    } else {
        // turns off the LED
        pin.write((polarity == LEDUtil::HIGH_ON_LOW_OFF) ? PIN_LOW : PIN_HIGH);
    }
}

void LEDUtil::turnOn()
{
    LEDUtil::setLedState(LEDUtil::LED_ON);
}

void LEDUtil::turnOff()
{
    LEDUtil::setLedState(LEDUtil::LED_OFF);
}

bool LEDUtil::isOn()
{
    if (getLedState() == LEDUtil::LED_ON) {
        return true;
    } else {
        return false;
    }
}

bool LEDUtil::isOff()
{
    return (!LEDUtil::isOn());
}

LEDUtil::LedState LEDUtil::getLedState()
{
    DigitalOut pin(pinName);
    LedState state = LEDUtil::LED_OFF;

    if (pin.read() == PIN_HIGH) {
        state = ((polarity == LEDUtil::HIGH_ON_LOW_OFF) ? LEDUtil::LED_ON : LEDUtil::LED_OFF);
    } else {
        state = ((polarity == LEDUtil::LOW_ON_HIGH_OFF) ? LEDUtil::LED_OFF : LEDUtil::LED_ON);
    }

    return state;
}

