#include "mbed.h"
#include "easy-connect.h"
#include "TLSSocket.h"

#include "mbed-trace/mbed_trace.h"

const char* HOST_NAME = "os.mbed.com";
const int PORT = 443;
const char* HTTPS_PATH = "/";

int main(int argc, char* argv[]) {
    mbed_trace_init();

    printf("HelloTSLSocket, HTTPS example of TLSSocket\r\n");
    printf("\r\n");

    // Open a network interface
    NetworkInterface* network = NULL;
    network = easy_connect(false);    // If true, prints out connection details.
    if (!network) {
        printf("Unable to open network interface.\r\n");
        return -1;
    }

    // Create a TLS socket
    TLSSocket socket = TLSSocket();
    if(socket.open(network) != 0) {
        printf("Unable to open TLS socket.\r\n");
        return -1;
    }

    // Set root CA certificate
    socket.set_root_ca_cert(MBED_CONF_APP_ROOT_CA_CERT_PEM);

    // Connect to the server, including TLS handshake
    if(socket.connect(HOST_NAME, PORT) != 0) {
        printf("Failed to connect to the server.");
        return -1;
    }
    
    const size_t buf_size = 1024;
    char *buf = new char[buf_size];

    // Send HTTP request
    /* "Connection: close" header is specified to detect end of the body
     * contents by connection close notification. If this is not specified,
     * connection is kept, and need to detect end of the content in another
     * way.
     */
    int len = snprintf(buf, buf_size, 
                "GET %s HTTP/1.1\n"
                "Host: %s\n"
                "Connection: close\n"
                "\n", HTTPS_PATH, HOST_NAME);
    printf("\r\n%s", buf);
    int rc = 0;
    rc = socket.send(buf, len);
    if(rc < 0) {
        printf("send error.\r\n");
        return -1;
    }

    // Receive response from the server
    while((rc = socket.recv(buf, buf_size - 1)) > 0) {
        buf[rc] = '\0';
        printf("%s", buf);
    }
    if(rc < 0) {
        printf("\r\n! Read failed. err code = %d\r\n", rc);
    }

    // Done
    printf("HelloTSLSocket DONE.\r\n");
    delete[] buf;
    
    socket.close();
}
