// USB Device demo - control mouse pointer with buttons

#include "mbed.h"
#include "USBMouse.h"
#include "MMA7660.h"
 
MMA7660 MMA(p28, p27);


// USB Mouse object
USBMouse mouse;

DigitalOut myled(LED1);

int main() {
    
    if (MMA.testConnection())myled = 1;
    int x = 0;
    int y = 0;


   while (1) {


        // Move mouse
        if (MMA.x()>0.3) x = 1;
        else if (MMA.x()<-0.3) x = -1;
        else x = 0;
        
        if (MMA.y()>0.3) y = 1;
        else if (MMA.y()<-0.3) y = -1;
        else y = 0;
        
        
        mouse.move(x, y);

        // Wait for next cycle
        wait(0.001);
    }
}
