#include <stdint.h>
#include "mbed.h"
#include "EthernetInterface.h"
#include "Keypad.h"

#define IP_SERVER       "192.168.2.102"
#define PORT_SERVER     4000
#define SUBNET          "255.255.255.0"
#define GATEWAY         "192.168.2.100"

#define MAX_BRIGHTNESS 255

//Serial pc(USBTX, USBRX);    //initializes the serial port
#ifdef TARGET_KL25Z 
PwmOut led(PTB18);  //initializes the pwm output that connects to the on board LED
DigitalIn INT(PTD1);  //pin PTD1 connects to the interrupt output pin of the MAX30102
#endif
#ifdef TARGET_K64F
DigitalIn INT(PTD1);  //pin PTD1 connects to the interrupt output pin of the MAX30102
#endif
#ifdef TARGET_MAX32600MBED
PwmOut led(LED_RED);    //initializes the pwm output that connects to the on board LED
DigitalIn INT(P2_0);  //pin P20 connects to the interrupt output pin of the MAX30102
#endif


DigitalOut led(LED1);


#define OTP_LENGTH 4
#define OTP_ENTER_CHAR '#'
char otpInput [OTP_LENGTH+1]; // a maximum of 256 characted can be stored
int  newOtp = 0; // when an otp is entered, this should be set to 1 by keypad_runner
                 // then, after the otp is sent over network, this must be reset to 0
#define MAX_INPUT 8
char keypadInput [MAX_INPUT]; // a maximum of 256 characted can be stored

void keypad_runner () {
    char key;
    int released = 1;
    uint16_t endPos = 0; // to implement a rotary indexing which covers 256 chars
    
    memset (keypadInput,0,MAX_INPUT);
    
    // Keypad kpad(col1, col2, col3, row1, row2, row3, row4);
    Keypad kpad(PTC12, PTC4, PTD0, PTB9, PTA1, PTB23, PTA2);
    while(1) {
        key = kpad.ReadKey();                   //read the current key pressed
        if(key == '\0')
            released = 1;                       //set the flag when all keys are released
        if((key != '\0') && (released == 1)) {  //if a key is pressed AND previous key was released
            // printf("key pressed: %c\n\r", key);            
            released = 0;                       //clear the flag to indicate that key is still pressed
            
            keypadInput[ endPos%MAX_INPUT ] = key;
            if(key == OTP_ENTER_CHAR) {
                for(int i=0; i<OTP_LENGTH; i++){
                    int k = (endPos-OTP_LENGTH+i)%MAX_INPUT;
                    otpInput[i] = keypadInput[k];
                    
                }
                otpInput[OTP_LENGTH]='\0';
                printf("%s", otpInput);
                printf("\r\n");
                newOtp = 1;                
            }
            endPos++;
        }
    }
}

void ethserver_runner () 
{
    EthernetInterface interface;
    interface.set_network(IP_SERVER,SUBNET,GATEWAY);
    interface.connect();
    // Show the network address
    SocketAddress a;
    interface.get_ip_address(&a);
    printf("IP address: %s\n", a.get_ip_address() ? a.get_ip_address() : "None");
    
    printf("IP Address is %s\n\r", interface.get_ip_address());
    return;
        
    //TCPServer srv;  //TCPServer was migrate to TCPSocket
    TCPSocket srv;
    TCPSocket *client_sock;  // srv.accept() will return pointer to socket
    SocketAddress client_addr;
    char *buffer = new char[1000];
    
    /* Open the server on ethernet stack */
    srv.open(&interface);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(interface.get_ip_address(), PORT_SERVER);
    
    /* Can handle x simultaneous connections */
    srv.listen(1);
 while (true) {
    client_sock = srv.accept();  //return pointer of a client socket
    client_sock->getpeername(&client_addr);  //this will fill address of client to the SocketAddress object
    printf("Accepted %s:%d\n", client_addr.get_ip_address(), client_addr.get_port());
   strcpy(buffer, "Hello \n\r");
    client_sock->send(buffer, strlen(buffer));
    client_sock->recv(buffer, 1000);
    printf("Received Msg: %s\n", buffer);  //this was missing in original example. 
    delete[] buffer;
    client_sock->close();
    
    }
}

Thread thread_keypad;
Thread thread_ethclient;

char buffer [256] = {0};
//void read_sensor_init();
//void read_sensor_continuous();
// #define UINT32_MAX 0xFFFFFFFF
int main()
{
    printf("Server example\n\r");
    
    thread_keypad.start(keypad_runner);
    thread_ethclient.start(ethserver_runner);
    
    thread_keypad.join();
    thread_ethclient.join();
    return 0;
        
    DigitalIn alarm(PTB9, PullUp); //internal pull up 
    
    EthernetInterface eth;
    eth.set_network(IP_SERVER,SUBNET,GATEWAY);
    eth.connect();
    
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    
    TCPServer srv(&eth);  
    srv.bind(PORT_SERVER);
    srv.set_blocking(false);
    srv.listen();
    
    //read_sensor_init();
    uint32_t alarm_counter = 1;
    uint32_t alarm_counter0 = 1;
    uint32_t threshold = 50;
    uint32_t maxval = 1000;  //= UINT32_MAX ; 

        TCPSocket client;
        SocketAddress client_addr;

    while(true)
    {
        led=(alarm==true);
        //read_sensor_continuous();
        
        
        srv.accept(&client, &client_addr);
        printf("Accepted %16s:%-5d", client_addr.get_ip_address(), 
                    client_addr.get_port());
        
        if(strcmp (client_addr.get_ip_address(), "0.0.0.0") == 0) {
            
        }
            
        
        // printf(" %c   (%zu)/(%zu)\n\r",ch, alarm_counter, UINT32_MAX);
            
        memset (buffer, 0, OTP_LENGTH+3);  // clear buffer
        if(newOtp) { // if there's new input, copy into buffer
            buffer[0]='^';
            memcpy(buffer+1, otpInput, OTP_LENGTH);
            buffer[OTP_LENGTH+1] = '^';
            buffer[OTP_LENGTH+2] = 0;
            printf("sending %s\r\n", buffer);
            newOtp = 0;      
        }        
        client.send(buffer, OTP_LENGTH+3);  
        
        client.close();
        
    }
    
    
    
    
}
