#include "mbed.h"
#include "TFC.h"

 
//This macro is to maintain compatibility with Codewarrior version of the sample.   This version uses the MBED libraries for serial port access
Serial PC(USBTX,USBRX);

#define TERMINAL_PRINTF     PC.printf

 
 //This ticker code is used to maintain compability with the Codewarrior version of the sample.   This code uses an MBED Ticker for background timing.
 
#define NUM_TFC_TICKERS 4

Ticker TFC_TickerObj;
 
volatile uint32_t TFC_Ticker[NUM_TFC_TICKERS];
 
void TFC_TickerUpdate()
{
    int i;
 
    for(i=0; i<NUM_TFC_TICKERS; i++)
     {
        if(TFC_Ticker[i]<0xFFFFFFFF) 
        {
            TFC_Ticker[i]++;
        }
    }
}
 
//finds light intensity values of lines.
 
int FindBlack();

// finds and sets by reference the values of the left and right bounds
void Bounds(int &, int &, int);
 
 
int main()
{
    uint32_t i,t,time = 0;
    
    int a = 200, b = 200;
    
    int data[128];
    
    int black = 0;
  
    PC.baud(9600);
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000);
   
    TFC_Init();
    
    bool timeTrue = true;
    
    for(;;)
    {      
        //TFC_Task must be called in your main loop.  This keeps certain processing happy (I.E. Serial port queue check)
         //   TFC_Task();

            //This Demo program will look at the middle 2 switch to select one of 4 demo modes.
            //Let's look at the middle 2 switches
            switch((TFC_GetDIP_Switch()>>1)&0x03)
            {
            default:
            case 0 :
            
            TFC_HBRIDGE_ENABLE;
                TFC_SetMotorPWM(.6,.6);
                
                    
            case 1:
                
                //Demo mode 1 will just move the servos with the on-board potentiometers
                if(TFC_Ticker[0]>=20)
                {
                    TFC_Ticker[0] = 0; //reset the Ticker
                    //Every 20 mSeconds, update the Servos
                    TFC_SetServo(0,TFC_ReadPot(0));
                    TFC_SetServo(1,TFC_ReadPot(1));
                    
                  
                }
                
                 if(TFC_PUSH_BUTTON_1_PRESSED)
                   { 
                   
                    TERMINAL_PRINTF("%f", TFC_ReadPot(0));
                    }
                
                
                //Let's put a pattern on the LEDs
                if(TFC_Ticker[1] >= 125)
                {
                    TFC_Ticker[1] = 0;
                    t++;
                    if(t>4)
                    {
                        t=0;
                    }           
                    TFC_SetBatteryLED_Level(t);
                }
                
              //  TFC_SetMotorPWM(0,0); //Make sure motors are off
              //  TFC_HBRIDGE_DISABLE;
            

                break;
                
            case 2 :
              
         
                //Demo Mode 3 will be in Freescale Garage Mode.  It will beam data from the Camera to the 
                //Labview Application
                
                
                if(TFC_Ticker[0]>50 && TFC_LineScanImageReady>0)
                    {
                     TFC_Ticker[0] = 0;
                     TFC_LineScanImageReady=0;
                    // TERMINAL_PRINTF("\r\n");
                    // TERMINAL_PRINTF("L:");
                     
                        if(t==0)
                            t=4;
                        else
                            t--;
                        
                         TFC_SetBatteryLED_Level(t);
                        
                         // camera 1
                         
                         if(TFC_PUSH_BUTTON_0_PRESSED)
                    {          
                  
                         
                         black = FindBlack();
                         
                         TERMINAL_PRINTF("%i", black);
                
                
               
                break;
            
            case 3 :
            
         
                //Demo Mode 3 will be in Freescale Garage Mode.  It will beam data from the Camera to the 
                //Labview Application
                
                
                if(TFC_Ticker[0]>50 && TFC_LineScanImageReady>0)
                    {
                     TFC_Ticker[0] = 0;
                     TFC_LineScanImageReady=0;
                    // TERMINAL_PRINTF("\r\n");
                    // TERMINAL_PRINTF("L:");
                     
                        if(t==0)
                            t=4;
                        else
                            t--;
                        
                         TFC_SetBatteryLED_Level(t);
                        
                         // camera 1
                         
                         if(TFC_PUSH_BUTTON_0_PRESSED)
                    {          
                               //Demo Mode 3 will be in Freescale Garage Mode.  It will beam data from the Camera to the 
                //Labview Application

                        
                         // camera 1
                         for(i=0;i<128;i++)
                         {
                               if(TFC_LineScanImage0[i]<=black)
                               {
                                   // zero is black
                                   
                                   data[i]=0;
                                }
                                else
                                {
                                    // one is white
                                    data[i]=1;
                                }
                                TERMINAL_PRINTF("%d", data[i]);
                         }
                         TERMINAL_PRINTF("\r");
                        
                        // camera 2
                      /*   for(i=0;i<128;i++)
                         {
                                 if(i==127)
                                     TERMINAL_PRINTF("%X\r\n",TFC_LineScanImage1[i]);
                                 else
                                     TERMINAL_PRINTF("%X,",TFC_LineScanImage1[i]);
                           
                         } */
                         
                      }   
                    }
                 
                break;
            }
    }
    
 
}
}
}

// finds and sets by reference the values of the left and right bounds

void bounds(int &a,int &b,int black)
{
 
     for(int i=0; i<128; i++)
     {
         if(TFC_LineScanImage0[i]==black&& i==0)
         {
             a = i;
         }
     
        else if(TFC_LineScanImage0[i]==black)
         {
            //if there are to black values next to eachother it sets a to newer inside value.
            
            if( (i-a) == 1 )
            {
                a = i;   
            }    
            
            // if there is a space between black values the next black value is the right bound.
            else
            {
              // sets the right inside bound and ends the loop.
              
              b = i;
              break;   
            }
         }
       } 
}         
 
    
  

int FindBlack()
{
    int low1=2000,low2=2000;
    for(int i=2;i<64;i++)//first half of line scan
    {
        int ave=(TFC_LineScanImage0[i-2]+TFC_LineScanImage0[i-1]+TFC_LineScanImage0[i])/3;
        if(i==2)
        {
            low1=ave;//first loop sets lowest average
        }
        if(low1>ave)
        {
            low1=ave;
        }
    }
    for(int i=66;i<128;i++)//second half of line scan
    {
        int ave2=(TFC_LineScanImage0[i-2]+TFC_LineScanImage0[i-1]+TFC_LineScanImage0[i])/3;
        if(i==66)
        {
            low2=ave2;
        }
        if(low2>ave2)
        {
            low2=ave2;
        }
        if(low1==low2)
        {
            return low1; //confirms bothe lines and breaks loop returns black
        }   
    }
    if(low1>low2)
    {
        return low1;
    }
    else
    {
        return low2;
    }
}    