/**
*
*
*
*
*/
#include "mbed.h"
#include "ezLCDLib.h"

enum { BLACK, GRAY, SILVER, WHITE, RED, MAROON, YELLOW, OLIVE, LIME, GREEN, AQUA, TEAL, BLUE, NAVY, FUCHSIA, PURPLE };

#ifdef MKL25Z4_H_
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "SDFileSystem.h"
SDFileSystem sd(PTD2, PTD3, PTD1, PTD5, "sd");
InterruptIn ezLCD3Int( PTD4 );   //  interrupt instance for touch
DigitalOut _nrst(PTC7);
DigitalOut rstVS(PTA13);
ezLCD3 lcd(PTA2, PTA1); //rx,tx
TSISensor tsi;
AnalogIn adc1(PTB0);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
DigitalOut myled(LED_RED);
#endif

#ifdef __LPC17xx_H__
InterruptIn ezLCD3Int( p7 );   //  interrupt instance for touch
DigitalOut _nrst(p8);
ezLCD3 lcd(p9, p10); //rx,tx
AnalogIn adc1(p20);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
#endif

// Serial for Debug
//Serial pc(USBTX, USBRX);

volatile bool ezLCD3Touch = false;

int color = BLACK;
int temp;
int touch=0;
int adc1Count = 0;
float adc1Average = 0;

char ezID[20];
char ezVER[20];
char adcBuf[20];
char buffer[80];
void ezLCD3Isr( void )
{
    ezLCD3Touch = true;
}
void drawKeyPad( int x, int y, int bs, int s, bool echo )
{
    lcd.setStringID(50,"0");
    lcd.setStringID(51,"1");
    lcd.setStringID(52,"2");
    lcd.setStringID(53,"3");
    lcd.setStringID(54,"4");
    lcd.setStringID(55,"5");
    lcd.setStringID(56,"6");
    lcd.setStringID(57,"7");
    lcd.setStringID(58,"8");
    lcd.setStringID(59,"9");
    lcd.setStringID(60,"<");
    lcd.setStringID(61,"0");
    lcd.setStringID(62,"EN");

    lcd.staticText(  50, x, y, (bs*3)-5, s, 8, 0, 4);
    y +=bs;
    lcd.button(51, x, y, s, s,1,0,10,0,51);
    lcd.button(52, x + bs, y, s, s,1,0,10,0,52);
    lcd.button(53, x + (bs*2), y, s, s,1,0,10,0,53);

    lcd.button(54, x, y + bs, s, s,1,0,10,0,54);
    lcd.button(55, x + bs ,y + bs, s, s,1,0,10,0,55);
    lcd.button(56, x + (bs*2), y + bs, s, s,1,0,10,0,56);

    lcd.button(57, x, y+(bs*2), s, s,1,0,10,0,57);
    lcd.button(58, x+bs, y+(bs*2), s, s,1,0,10,0,58);
    lcd.button(59, x+(bs*2), y+(bs*2), s, s,1,0,10,0,59);

    lcd.button(60, x, y+(bs*3), s, s,1,0,10,0,60);
    lcd.button(61, x+bs, y+(bs*3), s, s,1,0,10,0,61);
    lcd.button(62, x+(bs*2), y+(bs*3), s, s,1,0,10,0,62);

}
int main()
{
        //pc.baud(115200);
        _nrst=0;
        wait(0.1);
        _nrst=1;
//KL25Z    rstVS = 0;     
/*
    FILE *fp = fopen("/sd/sdtest.txt", "r");
    if(fp == NULL) {
        error("\r\nCould not open file for read\n");
    }
    */
    wait(4);
    while(!lcd.sync());
    ezLCD3Int.fall(&ezLCD3Isr);
    ezLCD3Touch = false;
    myled=0;
    lcd.cls(BLACK);
//    fgets(buffer, 64, fp);
//    lcd.print(buffer);
    lcd.font("0");
    lcd.fontw(0,0);
    lcd.theme(0, 111, 106, 3, 130, 0, 13, 12, 101, 100, 0);
    lcd.xy(0,0);//11
    lcd.color(WHITE);//3
    lcd.light(50);//8
    lcd.xy(40,10);//9
    lcd.print("--==[\\[28m Hello \\[65mMBED\\[28m World \\[3m]==--");//10
    lcd.xy(20,100);//11
    lcd.color(YELLOW);//12
    lcd.setStringID( 2,"Button1");
    lcd.setStringID( 3,"Button2");
    lcd.button(2,20,40,100,40,1,0,10,0,2);
    lcd.button(3,200,40,100,40,1,0,10,0,3);
    lcd.getStringID( 65,ezID);
    lcd.getStringID( 66,ezVER);
    lcd.print(ezID);
    lcd.color(PURPLE);
    lcd.xy(20,120);//11
    lcd.print(ezVER);
    lcd.color(TEAL);
    lcd.xy(20,140);
    lcd.printf("MaxX %d MaxY %d", lcd.getXmax()+1, lcd.getYmax()+1); //13 14
    lcd.light(5);//15
    lcd.light(100);//16
    lcd.image(20,165,"0.gif");
    lcd.image(55,165,"1.gif");
    lcd.image(90,165,"2.gif");
    lcd.image(125,165,"3.gif");
    lcd.color(WHITE);//17
    lcd.setStringID(4, "meter");
    lcd.setStringID(5, "%");
    lcd.setStringID(6, "X");
    lcd.setStringID(7, "Y");
    lcd.setStringID(8, "Z");
    lcd.wstack(CLEAR);

    lcd.staticText(  4, 200, 210, 100, 25, 8, 0, 4);
    lcd.progressBar( 5, 200, 180, 100, 25, 1, 0, 100, 0 , 5);
    lcd.progressBar( 6, 200, 90, 100, 25, 1, 0, 100, 0 , 6);
    lcd.progressBar( 7, 200, 120, 100, 25, 1, 0, 100, 0 , 7);
    lcd.progressBar( 8, 200, 150, 100, 25, 1, 0, 100, 0 , 8);

//    drawKeyPad(320,10,50,45,true);
    while(1) {
        if(ezLCD3Touch) {
            ezLCD3Touch = false;
            touch=lcd.wstack(LIFO);
            lcd.xy(10,210);
            lcd.color(BLACK);
            lcd.box(180,20,1);
            lcd.color(WHITE);
            switch( touch ) {
                case    240:
                    lcd.print("Button1 Pressed");
                    myled = 1;
                    break;
                case    214:
                    lcd.print("Button1 Released");
                    myled = 0;
                    break;
                case    224:
                    lcd.print("Button1 Cancel");
                    break;
                case    340:
                    lcd.print("Button2 Pressed");
                    myled = 1; 
                    break;
                case    314:
                    lcd.print("Button2 Released");
                    myled = 0;
                    break;
                case    324:
                    lcd.print("Button2 Cancel");
                    break;
/*
                case    5140:
                    lcd.print("1");
                    myled1 = 0;
                    break;
                case    5114:
                    lcd.print("1");
                    myled1 = 0;
                    break;
                case    5214:
                    lcd.print("2");
                    myled1 = 0;
                    break;
                case    5314:
                    lcd.print("3");
                    myled1 = 0;
                    break;
                case    5414:
                    lcd.print("4");
                    myled1 = 0;
                    break;
                case    5514:
                    lcd.print("5");
                    myled1 = 0;
                    break;
                case    5614:
                    lcd.print("6");
                    myled1 = 0;
                    break;
                case    5714:
                    lcd.print("7");
                    myled1 = 0;
                    break;
                case    5814:
                    lcd.print("8");
                    myled1 = 0;
                    break;
                case    5914:
                    lcd.print("9");
                    myled1 = 0;
                    break;
                case    6014:
                    lcd.print("<");
                    myled1 = 0;
                    break;
                case    6114:
                    lcd.print("0");
                    myled1 = 0;
                    break;
                case    6214:
                    lcd.print("EN");
                    myled1 = 0;
                    break;
*/
                default:
                    lcd.print("default");
                    break;
            }
        }
        adc1Average += adc1.read();
        adc1Count ++;
        if (adc1Count == 500) {
            adc1Count=0;
            sprintf(adcBuf, "%1.3f V",(adc1Average/500)*3.3);
            lcd.setStringID(4, adcBuf);
            lcd.wstate(4,REDRAW);
            adc1Average =0;
        }
        if(adc1Count ==250) {
           lcd.wvalue(5,abs( tsi.readPercentage()*100));
           lcd.wvalue(6,abs(acc.getAccX())*100);
           lcd.wvalue(7,abs(acc.getAccY())*100);
           lcd.wvalue(8,abs(acc.getAccZ())*100);
        }
    }

}