/**
*
*
*
*
*
*
*/


#include "mbed.h"
#include "ezLCDLib.h"

void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();

// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 64;
// might need to increase buffer size for high baud rates
char tx_buffer[buffer_size];
char rx_buffer[buffer_size];
// Circular buffer pointers
// volatile makes read-modify-write atomic
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;

char buf[64];

ezLCD3::ezLCD3(PinName tx, PinName rx) : Stream("ezLCD3") , _ser(tx, rx)
{
    _ser.baud(115200);               // default baud rate
    _ser.attach(this,&ezLCD3::Rx_interrupt, Serial::RxIrq);
}

void ezLCD3::Rx_interrupt( void )
{
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((_ser.readable()) || (((rx_in + 1) % buffer_size) == rx_out)) {
        rx_buffer[rx_in] = _ser.getc();
        rx_in = (rx_in + 1) % buffer_size;
    }
    return;
}

/* itoa:  convert n to characters in s */
void ezLCD3::itoa(int value, char *sp, int radix)
{
    char tmp[16];// be careful with the length of the buffer
    char *tp = tmp;
    int i;
    unsigned v;
    int sign;

    sign = (radix == 10 && value < 0);
    if (sign)   v = -value;
    else    v = (unsigned)value;

    while (v || tp == tmp) {
        i = v % radix;
        v /= radix; // v/=radix uses less CPU clocks than v=v/radix does
        if (i < 10)
            *tp++ = i+'0';
        else
            *tp++ = i + 'a' - 10;
    }

    if (sign)
        *sp++ = '-';
    while (tp > tmp)
        *sp++ = *--tp;
}

bool ezLCD3::sync( void )
{
    rx_in=0;
    rx_out=0;
    _ser.putc('\r');
    if(waitForCR())
        return true;
    else
        return false;

}
void ezLCD3::sendInt( int i )
{
    char value[5]= {0, 0, 0, 0, 0};
    itoa(i, value, 10);
    if(value[0]) _ser.putc(value[0]);
    if(value[1]) _ser.putc(value[1]);
    if(value[2]) _ser.putc(value[2]);
    if(value[3]) _ser.putc(value[3]);
    if(value[4]) _ser.putc(value[4]);
}

void ezLCD3::stripSpace(char* str)
{
    char* i = str;
    char* j = str;
    while(*j != 0) {
        *i = *j++;
        if(*i != ' ')
            i++;
    }
    *i = 0;
}

int ezLCD3::getInt( char *str )
{
    stripSpace(str);
    return atoi(str );
}

void ezLCD3::getString( char *str )
{
    char c=0;
    unsigned long timeOut=0;
    do {
        if(rx_in != rx_out) {
            c=rx_buffer[rx_out];
            rx_out = (rx_out + 1) % buffer_size;
            *str++ = c;
        }
        timeOut++;
    } while(c!='\r' && timeOut != 0xfffffff);
    *str--;
    *str = 0;
}

bool ezLCD3::waitForCR( void )
{
    char c=0;
    unsigned long timeOut=0;
    while(rx_in == rx_out) {
        if(timeOut++ > 0xffffff) return false;
    }
    c=rx_buffer[rx_out];
    rx_out = (rx_out + 1) % buffer_size;
    if(c == '\r') {
        return true;
    } else {
        return false;
    }
}

void ezLCD3::cls()
{
    sendInt(Clr_Screen);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::cls(int bColor)
{
    sendInt(Clr_Screen);
    _ser.putc(' ');
    sendInt(bColor);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::cls(int bColor, int fColor)
{
    sendInt(Clr_Screen);
    _ser.putc(' ');
    sendInt(bColor);
    _ser.putc(' ');
    sendInt(fColor);
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::color(int fColor)
{
    sendInt(Color);
    _ser.putc(' ');
    sendInt(fColor);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::xy(int x, int y)
{
    sendInt(XY);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::plot( void )
{
    sendInt(Plot);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::plot( int x, int y )
{
    sendInt(Plot);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::line(int x, int y )
{
    sendInt(Line);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::lineType( int type )
{
    sendInt(Line_Type);
    _ser.putc(' ');
    sendInt(type);
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::lineWidth( int width )
{
    sendInt(Line_Width);
    _ser.putc(' ');
    sendInt(width);
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::circle(int radius, bool filled)
{
    sendInt(Circle);
    _ser.putc(' ');
    sendInt(radius);
    if(filled) {
        _ser.putc(' ');
        _ser.putc('f');
    }
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::box(int width, int heigth, bool filled)
{
    sendInt(Box);
    _ser.putc(' ');
    sendInt(width);
    _ser.putc(' ');
    sendInt(heigth);
    if(filled) {
        _ser.putc(' ');
        _ser.putc('f');
    }
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::light(int level)
{
        sendInt( Light );
        putc(' ');
        sendInt( level );
        putc('\r');
        waitForCR();
}

int ezLCD3::getXmax( void )
{
    sendInt(Xmax);
    _ser.putc('\r');
    getString( buf );
    return getInt( buf );
}
int ezLCD3::getYmax( void )
{
    sendInt(Ymax);
    _ser.putc('\r');
    getString( buf );
    return getInt( buf );
}

void ezLCD3::sendString( char *str )
{
    unsigned char c;
    while( (c = *str++) )
        _ser.putc(c);
}

void ezLCD3::setStringID( int ID, char *str )
{
    sendInt(StringID);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    _ser.putc('\"');
    sendString(str);
    _ser.putc('\"');
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::getStringID( int ID , char *str)
{
    sendInt(StringID);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc('\r');
    getString(str);
}

void ezLCD3::print( char *str )
{
    sendInt(Print);
    _ser.putc(' ');
    _ser.putc('\"');
    sendString(str);
    _ser.putc('\"');
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::fontw( int ID, char *str)
{
    sendInt(Fontw);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    _ser.putc('\"');
    sendString(str);
    _ser.putc('\"');
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::fontw( int ID, int font)
{
    sendInt(Fontw);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(font);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::font( char *str)
{
    sendInt(Font);
    _ser.putc(' ');
    sendString(str);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::fontO( bool dir )
{
    sendInt(Font_Orient);
    _ser.putc(' ');
    if(dir)
        _ser.putc('1');
    else
        _ser.putc('0');
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::clipArea( int l, int t, int r, int b)
{
    sendInt(ClipArea);
    _ser.putc(' ');
    sendInt(l);
    _ser.putc(' ');
    sendInt(t);
    _ser.putc(' ');
    sendInt(r);
    _ser.putc(' ');
    sendInt(b);
    _ser.putc(' ');
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::clipEnable( bool enable)
{
    sendInt(ClipEnable);
    _ser.putc(' ');
    if(enable)
        _ser.putc('1');
    else
        _ser.putc('0');
    _ser.putc('\r');

}
void ezLCD3::theme(int ID, int EmbossDkColor, int  EmbossLtColor, int TextColor0, int TextColor1, int TextColorDisabled, int Color0, int Color1, int ColorDisabled, int CommonBkColor, int Fontw)
{
    sendInt(Widget_Theme);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(EmbossDkColor);
    _ser.putc(' ');
    sendInt(EmbossLtColor);
    _ser.putc(' ');
    sendInt(TextColor0);
    _ser.putc(' ');
    sendInt(TextColor1);
    _ser.putc(' ');
    sendInt(TextColorDisabled);
    _ser.putc(' ');
    sendInt(Color0);
    _ser.putc(' ');
    sendInt(Color1);
    _ser.putc(' ');
    sendInt(ColorDisabled);
    _ser.putc(' ');
    sendInt(CommonBkColor);
    _ser.putc(' ');
    sendInt(Fontw);
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::groupBox( int ID, int x, int y, int w, int h, int options, int theme, int stringID)
{
    sendInt(Set_Gbox);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    sendInt(w);
    _ser.putc(' ');
    sendInt(h);
    _ser.putc(' ');
    sendInt(options);
    _ser.putc(' ');
    sendInt(theme);
    _ser.putc(' ');
    sendInt(stringID);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::ameter( int ID, int x, int y, int w, int h, int options, int value, int min, int max, int theme, int stringID, int type)
{
    sendInt(Set_AMeter);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    sendInt(w);
    _ser.putc(' ');
    sendInt(h);
    _ser.putc(' ');
    sendInt(options);
    _ser.putc(' ');
    sendInt(value);
    _ser.putc(' ');
    sendInt(min);
    _ser.putc(' ');
    sendInt(max);
    _ser.putc(' ');
    sendInt(theme);
    _ser.putc(' ');
    sendInt(stringID);
    _ser.putc(' ');
    sendInt(type);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::touchZone( int ID, int x, int y, int w, int h, bool option)
{
    sendInt(Set_TouchZone);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    sendInt(w);
    _ser.putc(' ');
    sendInt(h);
    _ser.putc(' ');
    if(option)
        sendInt('1');
    else
        sendInt('0');
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::button( int ID, int x, int y, int w, int h, int option, int align, int radius, int theme, int stringID )
{
    sendInt(Set_Button);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    sendInt(w);
    _ser.putc(' ');
    sendInt(h);
    _ser.putc(' ');
    sendInt(option);
    _ser.putc(' ');
    sendInt(align);
    _ser.putc(' ');
    sendInt(radius);
    _ser.putc(' ');
    sendInt(theme);
    _ser.putc(' ');
    sendInt(stringID);
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::image( char *str )
{
    sendInt(Picture);
    _ser.putc(' ');
    _ser.putc('\"');
    sendString(str);
    _ser.putc('\"');
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::progressBar(int ID, int x, int y, int w, int h, int option, int value, int max, int theme, int stringID)
{
    sendInt(Set_Progress);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    sendInt(w);
    _ser.putc(' ');
    sendInt(h);
    _ser.putc(' ');
    sendInt(option);
    _ser.putc(' ');
    sendInt(value);
    _ser.putc(' ');
    sendInt(max);
    _ser.putc(' ');
    sendInt(theme);
    _ser.putc(' ');
    sendInt(stringID);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::slider(int ID, int x, int y, int w, int h, int option, int range, int res, int value, int theme)
{
    sendInt(Set_Slider);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    sendInt(w);
    _ser.putc(' ');
    sendInt(h);
    _ser.putc(' ');
    sendInt(option);
    _ser.putc(' ');
    sendInt(range);
    _ser.putc(' ');
    sendInt(res);
    _ser.putc(' ');
    sendInt(value);
    _ser.putc(' ');
    sendInt(theme);
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::image( int x, int y, char *str )
{
    sendInt(Picture);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    _ser.putc('\"');
    sendString(str);
    _ser.putc('\"');
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::staticText( int ID, int x, int y, int w, int h, int option, int theme, int stringID)
{
    sendInt(Set_StaticText);
    _ser.putc(' ');
    sendInt(ID);
    _ser.putc(' ');
    sendInt(x);
    _ser.putc(' ');
    sendInt(y);
    _ser.putc(' ');
    sendInt(w);
    _ser.putc(' ');
    sendInt(h);
    _ser.putc(' ');
    sendInt(option);
    _ser.putc(' ');
    sendInt(theme);
    _ser.putc(' ');
    sendInt(stringID);
    _ser.putc('\r');
    waitForCR();
}

unsigned int ezLCD3::wstack( int type )
{
    sendInt( Wstack );
    _ser.putc(' ');
    sendInt( type );
    _ser.putc('\r');
    getString( buf );
    return getInt( buf );
}
void ezLCD3::wvalue( int ID, int value)
{
    sendInt( Widget_Values );
    _ser.putc(' ');
    sendInt( ID );
    _ser.putc(' ');
    sendInt( value );
    _ser.putc('\r');
    waitForCR();
}
void ezLCD3::wstate( int ID, int option )
{
    sendInt( Widget_State );
    _ser.putc(' ');
    sendInt( ID );
    _ser.putc(' ');
    sendInt( option );
    _ser.putc('\r');
    waitForCR();
}

void ezLCD3::sendCommand(char *str)
{
    sendString(str);
    _ser.putc('\r');
    waitForCR();
}

int ezLCD3::_putc( int c)
{
    sendInt(Print);
    _ser.putc(' ');
    _ser.putc('\"');
    _ser.putc(c);
    _ser.putc('\"');
    _ser.putc('\r');
    waitForCR();
    return (c);
}

int ezLCD3::_getc(void)
{
    char r = 0;
    return(r);
}

int ezLCD3::putc ( int c )
{
    return(_ser.putc(c));
}

int ezLCD3::getc (void)
{
    return(_ser.getc());
}



