
#include "mbed.h"
#include "ezLCD405.h"

//DigitalOut led(LED1);

InterruptIn button(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX);
uint8_t counter;
uint32_t button_pressed;
volatile uint32_t tick;
//Thread *thread2;
uint8_t buttonPressed;
uint8_t buttState[10];

//ezLCD4 lcd(PB_6,PA_10); //tx,rx

ezLCD4 lcd(PG_14,PG_9); //tx,rx

//ezLCD4 lcd2(PA_11, PA_12);
const char *textBoxData[3][13];  

 
char temp[10];
uint16_t count, ocount;
uint16_t ox, oy;
uint32_t countdown;
void drawScreen( void );
void button_press(void)
{
    pc.printf("Button Press\n");
    lcd.showSettings();
//    lcd.printString(12,14,3, 0x0001, "mbed RTOS ezLCD405 Demo");
//   lcd.printString(10,12,3,WHITE,"mbed RTOS ezLCD405 Demo");

    //lcd.boxHFill(319,234);
//   thread2->signal_set(0x1);
}

void led_thread(void const *argument)
{
    while (true) {
        //  led = !led;
//       Thread::wait(100);
    }
}

void button_thread(void const *argument)
{
    while (true) {
//       Thread::signal_wait(100);
        button_pressed++;
    }
}


void drawFrame(uint16_t sx , uint16_t sy, uint16_t ex , uint16_t ey , uint16_t topColor, uint16_t bottomColor, uint8_t radius)
{
    lcd.setXY(sx, sy);
    lcd.setColor(topColor);
    lcd.setXY(sx+radius, sy+radius);
    lcd.arc(radius,270,0);
    lcd.setXY(sx+radius, sy);
    lcd.lineTo(ex-radius,sy);  //top
    lcd.setXY(sx, sy+radius);
    lcd.lineTo(sx,ey-radius);  //left
    lcd.setXY(sx+radius, ey-radius);
    lcd.arc(radius,180,270);

    lcd.setXY(sx+radius, ey);
    lcd.setColor(bottomColor);
    lcd.lineTo(ex-radius,ey);  //bottom
    lcd.setXY(ex-radius, ey-radius);
    lcd.arc(radius,90,180);
    lcd.setXY(ex, ey-radius);
    lcd.lineTo(ex,sy+radius);  //right
    lcd.setXY(ex-radius, sy+radius);
    lcd.arc(radius,0,90);
}
void drawScreen( void )
{

    lcd.setLayer(1);
    lcd.setTouchProtocol( TOUCH_EZ_BUTTON );

    lcd.createTextBox( 250 , 75, 500, 350, BLACK, GRAY, WHITE, 1, 6, " TextBox Test");
    lcd.setFont(4);
    lcd.printString(75,5,2, YELLOW, "mbed ezLCD-405", FONT_NORTH, OUTLINE, WHITE );
    

    count =0 ;
    ocount=0;
    lcd.status=0;

    lcd.createButton( 0, 1, 0 , 1, 1, 10, 60, 200, 50, 0);
    lcd.createButton( 1, 1, 2 , 3, 1, 10, 120, 200, 50, 0);
    lcd.createButton( 2, 1, 4 , 5, 1, 10, 180, 200, 50, 0);
    lcd.createButton( 3, 1, 6 , 7, 1, 10, 240, 200, 50, 0);


    //  lcd.createButton( 4, 1, 9 , 10, 1, 10, 300, 200, 50, 0);
}

void specScreen( void )
{
    lcd.buttonsDeleteAll();
    lcd.cls(BLACK);

    lcd.createButton( 10, 1, 10 , 11, 10, 10, 420, 200, 50, 0);
    lcd.printString(0,40,6,WHITE,"STM32F429 Cortex-4 Processor", FONT_NORTH, false, 0 );
    lcd.printString(0,70,6,WHITE,"5.6\" 640x480 16-bit Color TFT Display", FONT_NORTH, false, 0 );
    lcd.printString(0,100,6,WHITE,"Resistive or Capacitive Touch", FONT_NORTH, false, 0 );
    lcd.printString(0,130,6,WHITE,"SD Card Socket QuadBit SDIO", FONT_NORTH, false, 0 );
    lcd.printString(0,160,6,WHITE,"Battery Backed RTC", FONT_NORTH, false, 0 );
    lcd.printString(0,190,6,WHITE,"Expansion Header With I2C/SPI/UART", FONT_NORTH, false, 0 );

    wait(.5);

    while(lcd.pollTouch(1, 0x00)!=0x8a);
    lcd.buttonsDeleteAll();
    lcd.cls(BLACK);
    buttState[2]=1;
    drawScreen();
}
void fontDemo( void )
{
    lcd.buttonsDeleteAll();
    lcd.cls(BLACK);

    lcd.createButton( 10, 1, 10 , 11, 10, 10, 420, 200, 50, 0);

   
    lcd.printString(10,12,6,RED,"ezLCD-405 Font Demo", FONT_NORTH, OUTLINE, WHITE );

    lcd.printString(10,60,1,BLUE,"ezLCD-405 ", FONT_NORTH, SHADOW, WHITE );
    lcd.printString(10,100,2,BLUE,"ezLCD-405 ", FONT_NORTH, false, 0 );
    lcd.printString(10,150,3,BLUE,"ezLCD-405 ", FONT_NORTH, false, 0 );
    lcd.printString(10,200,4,BLUE,"ezLCD-405 ", FONT_NORTH, false, 0 );
    lcd.printString(10,250,5,BLUE,"ezLCD-405 ", FONT_NORTH, false, 0 );
    lcd.printString(10,300,6,BLUE,"ezLCD-405 ", FONT_NORTH, false, 0 );
    lcd.printString(10,350,7,BLUE,"ezLCD-405 ", FONT_NORTH, false, 0 );
    lcd.printString(10,400,8,BLUE,"ezLCD-405 ", FONT_NORTH, false, 0 );

//    Thread::wait(5000);
    wait(1);
    while(lcd.pollTouch(1, 0x00)!=0x8a);
    lcd.buttonsDeleteAll();
    lcd.cls(BLACK);
    buttState[1]=1;
    drawScreen();
}
void imageDemo( void )
{
    lcd.buttonsDeleteAll();
    lcd.cls(BLACK);

    lcd.printString(13,15,2, 0x0001, "ezLCD-405 Image Demo", FONT_NORTH, false, 0 );
    lcd.printString(10,12,2,WHITE,"ezLCD-405 Image Demo", FONT_NORTH, false, 0);
    lcd.setXY(10,240);
    lcd.putSfIcon(5);
//   Thread::wait(2000);
//        lcd.cls(BLACK);
    lcd.setXY(10,240);
    lcd.putSfIcon(6);
//    Thread::wait(2000);
//        lcd.cls(BLACK);
    lcd.setXY(10,240);
    lcd.putSfIcon(7);
//   Thread::wait(2000);
    lcd.cls(BLACK);

    drawScreen();
}

int main()
{
    textBoxData[0][0] =  "The ezLCD-405" ;
    textBoxData[1][0] =  "             " ;
    textBoxData[2][0] =  "0123456789012" ;
    
    button.mode(PullUp);
    button.fall(&button_press);
    pc.baud(115200);
    lcd.ezLCD405Init(SPI_IF);
    pc.printf("Start of Main\n");
    pc.printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);
    lcd.setLayerVisible(0,1);
    lcd.setLayerVisible(1,1);
    lcd.setLayer(1);
    lcd.setColorKey(0x0000);
    while(lcd.ping(100) !=1);
    lcd.lightOFF();

    lcd.exmode();
    lcd.cls(BLACK);
    lcd.setLayer(0);
    lcd.setXY(0,0);
    lcd.SDPutIcon("ezlcd405.bmp");
    lcd.textDirection( FONT_NORTH );
    lcd.lightON();
//    thread2 = new Thread(button_thread);
    buttState[0]=1;
    buttState[1]=1;
    buttState[2]=1;
    buttState[3]=1;
    buttState[4]=1;
    buttState[5]=1;

    drawScreen();

    while(1) {
        //wait(.05);
        buttonPressed = lcd.pollTouch(1, 0x00);

        if((buttonPressed & 0x40) == 0x40) {
            if(buttState[buttonPressed & 0x0f] == 1) {
                lcd.buttonState(buttonPressed & 0x0f, 2);
                buttState[buttonPressed & 0x0f] = 2;
            }
        }


        if((buttonPressed & 0x80) == 0x80) {
            if(buttState[buttonPressed & 0x0f] == 2) {
                lcd.buttonState(buttonPressed & 0x0f, 1);
                buttState[buttonPressed & 0x0f] = 1;
            }
        }
        if(buttState[2]==2) {
            specScreen();
        }
        if(buttState[1]==2) {
            fontDemo();
        }
        if(buttState[3]==2) {
            lcd.showSettings();
            wait(5);
            drawScreen();
        }
        lcd.setFont(3);
        lcd.setXY(20,300);
        count++;
        lcd.setColor(WHITE);
        sprintf(temp, "%d", count);
        lcd.printString(temp);
        //wait(.05);
        lcd.setXY(20,300);
        lcd.setColor(BLACK);
        lcd.boxFill(200,400);
        wait(.02);

//        lcd.printString(temp);
    }

    drawFrame(100 , 300, 300 , 400 , WHITE, GRAY, 5);
    drawFrame(100 +5 , 300+5 , 300-5 , 400-5 , GRAY, WHITE, 5);

    ocount=0;
    count=0;
    //lcd.setBgColorH(BLUE);
    while(1) {
        if(lcd.status == 1)
            drawScreen();
        //pc.printf("%d %d \n",lcd.x, lcd.y);
        sprintf(temp,"%d",count);
        if(lcd.button==0 && lcd.bState==1) {
            fontDemo();
        }

        if(lcd.button==1 && lcd.bState==1) {
            imageDemo();
        }
        if(lcd.button==2 && lcd.bState==1) {
            //   lcd.buttonState(lcd.button, 2);
//            lcd.buttonsDeleteAll();
//            lcd.showSettings();
//            Thread::wait(5000);
//            drawScreen();
        }
        if(lcd.button==3 && lcd.bState==1) {
            //   lcd.buttonState(lcd.button, 2);
            //specScreen();
        }
        if(count != ocount) {
            lcd.setXY(0,0);
            lcd.SDPutIcon("100_Single_Area.ezp");
            //lcd.printString(400, 100, 1, RED, temp);
            // lcd.printString(400, 200, 1, RED, temp);
            // lcd.printString(400, 300, 1, GREEN, temp);
            // lcd.printString(400, 400, 1, GREEN, temp);
            ocount=count;
        }
        countdown--;
        if(countdown == 0) {
            lcd.setXY(0,0);
            lcd.SDPutIcon("100_Single_Area_return.ezp");
            //  lcd.printString(400, 100, 1, BLACK, temp);
            //  lcd.printString(400, 200, 1, BLACK, temp);
//            lcd.printString(400, 300, 1, BLACK, temp);
//            lcd.printString(400, 400, 1, BLACK, temp);




            count++;
        }

    }
    button_pressed = 0;
    button.fall(&button_press);


    while (true) {
//        Thread::wait(6000);
        //lcd.printString("hello");
        lcd.direct(PRINT_STRING);
        printf("During the last 6 seconds, the Button was pressed %d times\n",   button_pressed);
        lcd.direct(0x00);
        fflush(stdout);
        button_pressed = 0;
    }
}
