#ifndef _CMDCODES_H_
#define _CMDCODES_H_



#define SERIAL_IF 1
#define SPI_IF 2


// Color Definitions
// R4 R3 R2 R1 | R0 G5 G4 G3 | G2 G1 G0 B4 | B3 B2 B1 B0
#define RED_0     0x0800
#define RED_1     0x1000
#define RED_2     0x2000
#define RED_3     0x4000
#define RED_4     0x8000
#define MAX_RED   0x1F
#define CL_RED(x)   (((uint16_t)x) << 11)

#define GREEN_0   0x0020
#define GREEN_1   0x0040
#define GREEN_2   0x0080
#define GREEN_3   0x0100
#define GREEN_4   0x0200
#define GREEN_5   0x0400
#define MAX_GREEN 0x3F
#define CL_GREEN(x) (((uint16_t)x) << 5)

#define BLUE_0    0x0001
#define BLUE_1    0x0002
#define BLUE_2    0x0004
#define BLUE_3    0x0008
#define BLUE_4    0x0010
#define MAX_BLUE  0x1F
#define NAVY      BLUE_4
#define CL_BLUE(x)  ((uint16_t)x)

#define CL_GRAY(x) (CL_RED(x) | CL_GREEN((x << 1)) | CL_BLUE(x))

#define RED     CL_RED(MAX_RED)
#define GREEN   CL_GREEN(MAX_GREEN)
#define BLUE    CL_BLUE(MAX_BLUE)

#define YELLOW  (RED | GREEN)
#define ORANGE  (RED | CL_GREEN(MAX_GREEN >> 1))
#define LIGHT_YELLOW (RED | CL_GREEN(0x3B) | CL_BLUE(0x19))
#define WHITE   (RED | GREEN | BLUE)
#define BLACK   0x0000
#define GRAY    (CL_RED(MAX_RED >> 1) | CL_GREEN(MAX_GREEN >> 1) |  CL_BLUE(MAX_BLUE >> 1))
#define GOLD (GREEN_5 + GREEN_4 + GREEN_3 + RED)


// ############################################################################
// ##  EZLCD COMMAND CODES  ###################################################
// ############################################################################

#define EXMODE               0xFB
#define STDMODE              0xFC
#define GETSERIAL            0xFD
#define SHOWSETTINGS         0xFE
#define CALIBRATE            0xEF

#define CLS                  0x21
#define LIGHT_ON             0x22
#define LIGHT_OFF            0x23
#define SET_COLOR            0x24
#define SET_XY               0x25
#define PLOT                 0x26
#define PLOT_XY              0x27
#define LINE_TO_XY           0x28
#define CIRCLE_R             0x29
#define SCR_BMP              0x2A
#define SELECT_FONT          0x2B
#define PRINT_CHAR           0x2C
#define PRINT_STRING         0x2D
#define PUT_BITMAP           0x2E
#define ARC                  0x2F

#define PIE                  0x30

#define SET_LAYER             0x31
#define SET_COLORKEY          0x32
#define SET_LAYERVISIBLE      0x33

#define SET_BG_COLOR         0x34
#define SAVE_POSITION        0x35
#define RESTORE_POSITION     0x36
#define CIRCLE_R_FILL        0x39
#define PRINT_CHAR_BG        0x3C
#define PRINT_STRING_BG      0x3D

#define H_LINE               0x40
#define V_LINE               0x41
#define BOX                  0x42
#define BOX_FILL             0x43

#define PICTURE_ROM          0x50
#define PUT_ICON             0x57
#define PUT_SF_ICON          0x58

#define SET_X                0x5E
// 1: x
#define SET_Y                0x5F
// 1: y

#define FONT_NORTH           0x60
#define FONT_EAST            0x61
#define FONT_SOUTH           0x62
#define FONT_WEST            0x63

#define SET_XH               0x6E
// 1: xh 2: xl

#define SD_PUT_ICON          0x70
// 1 - 64: NULL terminated path
#define SD_FILE_OPEN         0x71
// 1: File ID (1 to 255)
// 2 - 65: NULL terminated path
// Response:
// 0: 0x3F
// 1: 0 = Error, ID = Success
#define SD_FILE_CLOSE        0x72
// 1: File ID (1 to 255)
#define SD_FILE_CLOSE_ALL    0x73
#define SD_FILE_GET_SIZE     0x74
// 1: File ID (1 to 255)
// Response:
// 0: 0x3D
// 1-4: File Size (0 = Error)
// or
// 0: 0x3E - Error
#define SD_FILE_READ         0x75
// 1: File ID (1 to 255)
// 2-5: Number of Bytes
// Response:
// 0: 0x3C
// 1-n: Bytes Read
// or
// 0: 0x3E - Error
#define SD_FILE_CREATE       0x76
// 1: File ID (1 to 255)
// 2 - 65: NULL terminated path
// Response:
// 0: 0x3F
// 1: 0 = Error, ID = Success
#define SD_SCREEN_CAPTURE    0x44
// Response:
// 0: 0x3B - Success
//    0x3E - Error

#define SD_FOLDER_CREATE     0x46
// 1 - 64: NULL terminated path
// Response:
// 0: 0x3B - Success
//    0x3E - Error
#define SD_FOLDER_DELETE     0x4D
// 1 - 64: NULL terminated path
// Response:
// 0: 0x3A - Success
//    0x3E - Error
#define SD_FORMAT            0x4F
// 1 - 5: File system (FAT12, FAT16, FAT32)
// Response:
// 0: 0x3A - Success
//    0x3E - Error
#define SD_FILE_WRITE        0x77
// 1: File ID (1 to 255)
// 2-5: Number of Bytes (n)
// 6-(n+5): Data to write
// Response:
// 0: 0x3B - Success
//    0x3E - Error

#define SD_SPACE_INFO        0x48
// 1: What (1: Free Space, 2: Used Space, 3: in Bad Sectors, Other: Total Space
// Response:
// 0: 0x3D
// 1-4: Space Info (0 = Error)
// or
// 0: 0x3E - Error

#define SD_INSERTED         0x49
// Response:
// 0: 0x3D - Inserted
// 0: 0x3E - Error

#define SD_SIZE              0x78
// Response:
// 0: 0x3D
// 1-4: SD Size (0 = Error)
// or
// 0: 0x3E - Error

#define SD_FILE_LIST          0x79
// 1 - 64: NULL terminated dir path
// Response:
// 0: 0x3A
// 1 - whatever: NULL terminated dir string
//     Files separated by new_line
// or
// 0: 0x3E - Error

#define SD_FIND_FIRST          0x4A
// 1 - F_MAXLNAME: NULL terminated dir path
// Response:
// 0: 0x3A
// 1 - whatever: NULL terminated string
// or
// 0: 0x3E - Error
#define SD_FIND_NEXT           0x4B
// Response:
// 0: 0x3A
// 1 - whatever: NULL terminated string
// or
// 0: 0x3E - Error

#define SD_FILE_REWIND       0x7A
// 1: File ID (1 to 255)
// Response:
// 0: 0x39 - Success
//    0x3E - Error
#define SD_FILE_TELL         0x7B
// 1: File ID (1 to 255)
// Response:
// 0: 0x3D
// 1-4: Position
// or
// 0: 0x3E - Error

#define SD_FILE_SEEK         0x7C
// 1: File ID (1 to 255)
// 2-5: Signed Offset
// 6: whence
//           SD_SEEK_SET    0   File beginning
//           SD_SEEK_CUR    1   Current file pointer position
//           SD_SEEK_END    2   End-of-file
// Response:
// 0: 0x39 - Success
//    0x3E - Error
#define SD_SEEK_SET 0   // File beginning
#define SD_SEEK_CUR 1   // Current file pointer position
#define SD_SEEK_END 2   // End-of-file

#define SD_FILE_DELETE       0x7D
// 1 - 64: NULL terminated path
// Response:
// 0: 0x3A - Success
//    0x3E - Error

#define SD_RAW_READ          0x7E
// 1: 0xA5
// 2-5: Address
// 6-9: Length
// Response:
// 0: 0x3C
// 1-n: Bytes Read
// or
// 0: 0x3E - Error

#define SD_RAW_WRITE         0x7F
// 1: 0xA5
// 2-5: Address
// 6-9: Length
// 10-(n+9): Data to write
// Response:
// 0: 0x3B - Success
//    0x3E - Error

// TO DO in SD:
// f_setattr
// f_getattr

#define LIGHT_BRIGHT         0x80
#define PING                 0x83
// Response:
// 0: 0x38
#define SET_COLORH           0x84
#define SET_XHY              0x85
#define PLOT_XHY             0x87
#define LINE_TO_XHY          0x88
#define CIRCLE_RH            0x89
#define PUT_COMPR_BMPH       0x8D // Not implemented
#define ARCH                 0x8F

#define PIEH                 0x90
#define SET_BG_COLORH        0x94
#define CIRCLE_RH_FILL       0x99
#define PUT_BITMAPH          0x9E

#define H_LINEH              0xA0
#define BOXH                 0xA2
#define BOXH_FILL            0xA3

// Touch
#define BUTTON_DEF           0xB0
// 1: ID
// 2: State 0: None, 1: UP, 2: DN, 3: Disabled, 4: Non-Visible
// 3: IconUP
// 4: IconDN
// 5: IconDis
// 6: x0 MSB
// 7: x0 LSB
// 8: y0
// 9: Width
//10: Height
#define BUTTON_STATE         0xB1
// 1: ID
// 2: State
#define TOUCH_PROTOCOL       0xB2
// 1: Protocoles on/off (coded in 8 bits)
#define ALL_BUTTONS_UP       0xB3
#define ERASE_ALL_BUTTONS    0xB4

#define USB_DISABLE_RS232    0xC0
#define USB_DISABLE_SPI      0xC1
#define USB_ENABLE_RS232     0xC2
#define USB_ENABLE_SPI       0xC3

// ezNOW Buzzer
#define EZNOW_BUZZER_OFF     0xD0
#define EZNOW_BUZZER_ON      0xD1
#define EZNOW_BUZZER_BEEP    0xD2
// 1: Beep time [0.01s]

// Serial EEPROM
#define SE_BYTE_OUT          0xE0
#define SE_BYTE_WR           0xE1
#define SE_DATA_OUT          0xE2
#define SE_WAIT_END          0xE3
#define SE_ERASE_SECTOR      0xE4
#define SE_BYTE_RD           0xE5
#define SE_BULK_ERASE        0xE6
#define SE_PROGRAM_PAGE      0xE7
#define SE_READ_BAT          0xE8

// AVR (ATmega8) Flash Programming
#define AVR_PROG             0xF0
// 1 - 15: password
#define EZNOW_AVR_PROG       0xF3
// 1: Speed
// 2 - 16: password
// The following AVR commands are available only
// after AVR_PROG or EZNOW_AVR_PROG command has been received
#define AVR_PROG_CMD          0xF1
// 1 - 4: Bytes 1 - 4 of AVR Serial Programming Instruction
#define AVR_PROG_CMD_FAST     0xF4
// 1 - 4: Bytes 1 - 4 of AVR Serial Programming Instruction
#define AVR_PROG_CMD_NO_DELAY 0xF6
// 1 - 4: Bytes 1 - 4 of AVR Serial Programming Instruction
#define AVR_PROG_CMDS_PACK    0xF7
// 1 No of Prog commands
// 2 - 257 (64*4-1) Prog commands (4 bytes each)
#define AVR_WRITE_POLL        0xF8
// 1 - Command
// 2 - Address MSB
// 3 - Address LSB
// 4 - Data
#define AVR_WRITE_PAGE        0xF2
// 1: Page No
// 2 - 65: Bytes 0 - 63 of the page
#define AVR_SUCCESS           0xF5
#define RESET_EZLCD           0xFA

// ############################################################################
// ##  EZLCD OUTPUT CODES  ####################################################
// ############################################################################

// Touch Screen Output
#define ID_TOUCH_X      0x81
#define ID_TOUCH_Y      0x82
#define ID_TOUCH_PEN_UP 0x83
//#define ID_CAL_TOUCH_X  0x84
//#define ID_CAL_TOUCH_Y  0x85
#define ID_BUTTON_DN    0x86
#define ID_BUTTON_LEAVE 0x87

#define EZLCD_READY     0xEA
#define PONG 0x38

// ############################################################################
// ##  OTHER DEFINITIONS  #####################################################
// ############################################################################

#define STX 0x02
#define ETX 0x03
#define ACK 0x06
#define NAK 0x15

#define TOUCH_EZ_BUTTON   0x01
#define TOUCH_CU_BUTTON   0x02
#define TOUCH_CALIBRATED  0x40
#define timedOut 0x2
#define OUTLINE 1
#define SHADOW 2

class ezLCD4: public Stream
{
public:
    /** Create a new interface to a ezLCD3xx display
     * @param tx -- mbed transmit pin
     * @param rx -- mbed receive pin
     */
    volatile uint8_t status;
    volatile uint8_t pong;
    volatile uint8_t button;
    volatile uint8_t bState;
    volatile uint16_t x,y;
    ezLCD4(PinName tx, PinName rx);
    /**
    *
    *
    */
    void Rx_interrupt( void );
    void Tx_interrupt( void );
    void send_line();
    /**
    *
    *
    */
    uint8_t getByte( void );
    uint8_t getCount( void );
    void cls( void );
    void cls( uint16_t color);
    void lightON( void );
    void lightOFF( void );
    void lightBright( uint8_t bright );
    void setTouchProtocol( uint8_t protocol);
    uint16_t getX( void );
    uint16_t getY( void );
    void putSfIcon( uint8_t icon );

    void vLine( uint8_t y);
    void hLine( uint8_t x);
    void hLineH( uint16_t x);
    void setLayer ( uint8_t layer );
    void setLayerVisible ( uint8_t layer, uint8_t visible );
    void setColorKey ( uint16_t color );
    void SDPutIcon( char *str );
    void textDirection( uint8_t dir );
    void buttonState( uint8_t ID, uint8_t state );
    void buttonsDeleteAll( void );
    void showSettings( void );
    void buzzerOn( void );
    void buzzerOff( void );
    void lineTo( uint16_t x , uint16_t y );
    void beep( uint8_t duration );
    /**
    *
    *
    */
    void printString( char *str );
    /**
    *
    *
    */
    void printString( uint16_t x, uint16_t y, uint8_t font, uint16_t color, char *str , uint8_t dir, uint8_t efx, uint16_t ocolor);
    /**
    *
    *
    */
    void ezLCD405Init( uint8_t iface );
    /**
    *
    *
    */
    void exmode( void );
    /**
    *
    *
    */
    void stdmode( void );
    /**
    *
    *
    */
    void setColor(uint16_t color);
    /**
    *
    *
    */
    void setBgColor(uint16_t color);
    /**
    *
    *
    */
    void setFont(unsigned char font);
    /**
    *
    *
    */
    void direct( unsigned char c );
    /**
    *
    *
    */
    void setXY( uint16_t x, uint16_t y);
    /**
    *
    *
    */
    void box( uint16_t x, uint16_t y);
    /**
    *
    *
    */
    void boxFill( uint16_t x, uint16_t y);
    /**
    *
    *
    */
    void arc(uint16_t radius, uint16_t begin, uint16_t end);
    /**
    *
    *
    */
    uint8_t createButton( uint8_t ID, uint8_t State, uint8_t IconUp, uint8_t IconDn, uint8_t IconDis, uint16_t X, uint16_t Y, uint16_t W, uint16_t H, uint8_t Callback);
    /**
    *
    *
    */
    uint8_t pollTouch( uint8_t count , uint8_t cmd);
    /**
    *
    *
    */
    uint8_t ping( uint16_t timeout );
    
    void createTextBox( uint16_t x , uint16_t y, uint16_t w, uint16_t h, uint16_t bcolor, uint16_t fcolor, uint16_t tcolor, uint16_t fsize, uint8_t font, char *str);
private:
    Serial _ser;
    virtual int _putc(int c);
    virtual int _getc();
    void send16MSB( uint16_t val );
    void send16LSB( uint16_t val );
    uint8_t writeData(uint8_t c);
};



#endif
