#include "mbed.h"
#include "ezLCD405.h"


void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();

Timer timer;

// MOSI = PA7
// MISO = PA6
// SCK  = PA5
// NSS  = PA_4

SPI device(PA_7, PA_6, PA_5, PA_4);
DigitalOut nss(PA_4);

// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 4096;
// might need to increase buffer size for high baud rates
char tx_buffer[buffer_size];
char rx_buffer[buffer_size];
// Circular buffer pointers
// volatile makes read-modify-write atomic
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
char buf[64];
uint8_t ExtendedMode=0;

uint8_t interface = SPI_IF;

ezLCD4::ezLCD4(PinName tx, PinName rx) : Stream("ezLCD4") , _ser(tx, rx)
{
//   _ser.attach(this,&ezLCD4::Rx_interrupt, Serial::RxIrq);
    //  _ser.attach(this,&ezLCD4::Tx_interrupt, Serial::TxIrq);
    _ser.baud(115200);               // default baud rate
    status = 0;

}

void ezLCD4::Rx_interrupt( void )
{
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
//    while ((_ser.readable()) || (((rx_in + 1) % buffer_size) == rx_out)) {
//        rx_buffer[rx_in] = _ser.getc();
//        rx_in = (rx_in + 1) % buffer_size;
//    }
    uint8_t c;
    if(_ser.readable()) {
        c=_ser.getc();
        //status=c;
        //    if(c==0xea)
        //       status=1;
        //  if(c==0x38)
        //      pong=1;
        /*
               if((c & 0xc0)==0x40) {
                   button=(c & 0x3f);
                   bState=1;
        //            beep(5);
               }
               if((c & 0xc0)==0x80) {
                   button=(c & 0x3f);
                   bState=0;
               }
        */


        if(c == 0x81) {
            while(!_ser.readable());
            x = _ser.getc();
            while(!_ser.readable());
            x |= _ser.getc() << 7;
            while(!_ser.readable());
            y = _ser.getc();
            while(!_ser.readable());
            y = _ser.getc();
            while(!_ser.readable());
            y |= _ser.getc() << 7;
        }

    }
    return;
}

// Interupt Routine to write out data to serial port
void ezLCD4::Tx_interrupt( void )
{
//    led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    /*
        while (( _ser.writeable() ) && (tx_in != tx_out)) {
            _ser.putc(tx_buffer[tx_out]);
            tx_out = (tx_out + 1) % buffer_size;
        }
        //  led2=0;
        return;
        */
}



uint8_t ezLCD4::getByte( void )
{
    return rx_buffer[rx_out];
}
uint8_t ezLCD4::getCount( void )
{
    return rx_in;
}

void ezLCD4::ezLCD405Init( uint8_t iface )
{
    /*
        while(c!=PONG) {

            _ser.putc(PING);
            c=pc.getc();
        }
    */
    //writeData(0x00);
    interface = iface;
    if(interface == SPI_IF) {
        nss=1;
        device.format(8,3);
        device.frequency(10000000);
    }

}
void ezLCD4::showSettings( void )
{
    writeData(SHOWSETTINGS);
}
void ezLCD4::buzzerOn( void )
{
    writeData(EZNOW_BUZZER_ON );
}
void ezLCD4::buzzerOff( void )
{
    writeData(EZNOW_BUZZER_OFF );
}

void ezLCD4::beep( uint8_t duration )
{
    writeData(EZNOW_BUZZER_BEEP );
    writeData(duration);
}

void ezLCD4::lightON( void )
{
    writeData(LIGHT_ON);
}

void ezLCD4::lightOFF( void )
{
    writeData(LIGHT_OFF);
}

void ezLCD4::lightBright( uint8_t bright )
{
    writeData(LIGHT_BRIGHT);
    writeData(bright);
}
void ezLCD4::setTouchProtocol( uint8_t protocol)
{
    writeData(TOUCH_PROTOCOL);
    writeData(protocol);
}

void ezLCD4::putSfIcon( uint8_t icon )
{
    writeData(PUT_SF_ICON);
    writeData(icon);
}

void ezLCD4::direct( uint8_t c )
{
    writeData(c);
}

void ezLCD4::exmode( void )
{
    writeData(EXMODE);
    ExtendedMode=true;
}
void ezLCD4::stdmode( void )
{
    writeData(STDMODE);
    ExtendedMode =false;
}
void ezLCD4::setLayer ( uint8_t layer )
{
    writeData(SET_LAYER);
    writeData(layer);
}
void ezLCD4::setLayerVisible ( uint8_t layer, uint8_t visible )
{
    writeData(SET_LAYERVISIBLE);
    writeData(layer);
    writeData(visible);
}
void ezLCD4::setColorKey ( uint16_t color )
{
    writeData(SET_COLORKEY);
    writeData(color & 0x00ff);
    writeData((color & 0xff00) >>8);
}
void ezLCD4::SDPutIcon( char *str )
{
    writeData(SD_PUT_ICON);
    while( (char) *str )
        writeData((char) *str++);
    writeData(0x00);
}
void ezLCD4::setColor( uint16_t color )
{
    writeData(SET_COLORH);
    writeData(color & 0x00ff);
    writeData((color & 0xff00) >>8);
}
void ezLCD4::setBgColor( uint16_t color )
{
    writeData(SET_BG_COLORH);
    writeData(color & 0x00ff);
    writeData((color & 0xff00) >>8);
}
void ezLCD4::cls( void )
{
    writeData(CLS);
}

void ezLCD4::cls( uint16_t color)
{
    writeData(SET_COLORH);
    send16LSB( color );
    writeData(CLS);
}
void ezLCD4::setXY( uint16_t x, uint16_t y)
{
    writeData(SET_XHY);
    send16MSB( x );
    if(ExtendedMode == false)
        writeData(y & 0x00ff);
    else
        send16MSB( y );
}
void ezLCD4::printString( char *str )
{
    writeData(PRINT_STRING);
    while( (char) *str )
        writeData((char) *str++);
    writeData(0x00);
}
void ezLCD4::textDirection( uint8_t dir )
{
    writeData( dir );
}

void ezLCD4::printString( uint16_t x, uint16_t y, uint8_t font, uint16_t color, char *str , uint8_t dir, uint8_t efx, uint16_t ocolor)
{
    writeData( dir );
    writeData(SELECT_FONT);
    writeData(font);
    if(efx==OUTLINE) 
    {
    setXY(x-1,y);
    setColor(ocolor);    
    printString(str);

    setXY(x+1,y);
    setColor(ocolor);    
    printString(str);
   
    setXY(x,y-1);
    setColor(ocolor);    
    printString(str);

    setXY(x,y+1);
    setColor(ocolor);    
    printString(str);
    }
    if(efx==SHADOW)
    {
    setXY(x+1,y+1);
    setColor(ocolor);    
    printString(str);        
    }  
        
    setXY(x,y);
    setColor(color);    
    printString(str);  
}
void ezLCD4::setFont( uint8_t font )
{
    writeData(SELECT_FONT);
    writeData(font);
}

void ezLCD4::lineTo( uint16_t x , uint16_t y )
{
    writeData( LINE_TO_XHY ) ;
    send16MSB( x );
    if(ExtendedMode == false)
        writeData(y & 0x00ff);
    else
        send16MSB( y );
}
void ezLCD4::vLine( uint8_t y)
{
    writeData(V_LINE);
    writeData(y );
}
void ezLCD4::hLine( uint8_t x)
{
    writeData(H_LINE);
    writeData( x );
}

void ezLCD4::hLineH( uint16_t x)
{
    writeData(H_LINEH);
    send16MSB( x );

}
void ezLCD4::arc(uint16_t radius, uint16_t begin, uint16_t end)
{
    writeData(ARCH);

    writeData((radius & 0xff00) >>8);
    writeData(radius & 0x00ff);
    begin *=2048/45;
    writeData((begin & 0xff00) >>8);
    writeData(begin & 0x00ff);
    end *=2048/45;
    writeData((end & 0xff00) >>8);
    writeData(end & 0x00ff);
}
void ezLCD4::box( uint16_t x, uint16_t y)
{
    writeData(BOXH);
    send16MSB( x );
    if(ExtendedMode == false)
        writeData( y & 0x00ff );
    else
        send16MSB( y );

}
void ezLCD4::boxFill( uint16_t x, uint16_t y)
{

    writeData(BOXH_FILL);
    send16MSB( x );
    if(ExtendedMode == false)
        writeData( y & 0x00ff );
    else
        send16MSB( y);
}
void ezLCD4::createTextBox( uint16_t x , uint16_t y, uint16_t w, uint16_t h, uint16_t bcolor, uint16_t fcolor, uint16_t tcolor, uint16_t fsize, uint8_t font, char *str)
{
    setXY(x, y);
    setColor(bcolor);
    //boxFill(w,h);
    setXY(x,y);
    setColor(fcolor);
    box(w,h);
    setFont(font);
    printString( x, y, font, tcolor, str , FONT_NORTH , false, 0);
}

void ezLCD4::buttonsDeleteAll( void )
{
    writeData( ERASE_ALL_BUTTONS );
}

// #define BUTTON_DEF           0xB0
// 1: ID
// 2: State 0: None, 1: UP, 2: DN, 3: Disabled, 4: Non-Visible
// 3: IconUP
// 4: IconDN
// 5: IconDis
// 6: x0 MSB
// 7: x0 LSB
// 8: y0
// 9: Width
//10: Height
uint8_t ezLCD4::createButton( uint8_t ID, uint8_t State, uint8_t IconUp, uint8_t IconDn, uint8_t IconDis, uint16_t X, uint16_t Y, uint16_t W, uint16_t H, uint8_t Callback)
{
    writeData(BUTTON_DEF);
    writeData(ID);
    writeData(State);
    writeData(IconUp);
    writeData(IconDn);
    writeData(IconDis);
    send16MSB( X );
    if(ExtendedMode == false)
        writeData( Y & 0x00ff );
    else
        send16MSB( Y );
    writeData( W );
    writeData( H );
    return true;
}
void ezLCD4::buttonState( uint8_t ID, uint8_t state )
{
    writeData( BUTTON_STATE );
    writeData( ID );
    writeData( state );
}

void ezLCD4::send16MSB( uint16_t val )
{
    writeData(( val & 0xff00) >>8);
    writeData( val & 0x00ff);
}
void ezLCD4::send16LSB( uint16_t val )
{
    writeData( val & 0x00ff);
    writeData(( val & 0xff00) >>8);
}
uint8_t ezLCD4::ping( uint16_t timeout )
{
    timer.reset();
    writeData(PING);
    timer.start();
    while(timer.read_ms() < timeout) {
        if( pollTouch(1, 0x00) == 0x38)
            return true;
    }
    timer.stop();
    return timedOut;

}



uint8_t ezLCD4::pollTouch( uint8_t count, uint8_t cmd )
{
    uint8_t c;
    c = 0x00;
    if(interface == SPI_IF) {
        nss=0;
        for(uint8_t i=0; i< count; i++)
            c=device.write(cmd);
        nss=1;
    }
    return c;
}

uint8_t ezLCD4::writeData(uint8_t c)
{
    if(interface == SERIAL_IF)
        _ser.putc(c);
    if(interface == SPI_IF) {
        nss=0;
        device.write(c);
        nss=1;

    }
}

int ezLCD4::_putc( int c)
{

    return (c);
}

int ezLCD4::_getc(void)
{
    char r = 0;
    return(r);
}
