#include "mbed.h"
#include "ILI9341_Defines.h"

SPI spi_dev(PB_15, PB_14, PB_13);
DigitalOut cs(PC_4);
DigitalOut ao(PB_3);
uint8_t tarr[1024];
uint8_t rarr[1024];

void writecommand(uint8_t command) {
    cs = 0;
    ao = 0;
    spi_dev.write(command);
    cs = 1;
}

void writedata(uint8_t data) {
    cs = 0;
    ao = 1;
    spi_dev.write(data);
    cs = 1;
}

void setAddress(uint8_t x1, uint8_t y1, uint8_t x2, uint8_t y2) {
    writecommand(0x2a);
    writedata(0x00);
    writedata(x1);
    writedata(0x00);
    writedata(x2);
    writecommand(0x2b);
    writedata(0x00);
    writedata(y1);
    writedata(0x00);
    writedata(y2);
    writecommand(0x2c);
}

void writeColorData(uint8_t * arr, int length) {
    cs = 0;
    ao = 1;
    spi_dev.write((char*)arr, length, NULL, length);
    cs = 1;
}

int main() {
    HAL_Init();
    #include "ILI9341_Init.h"
    setAddress(0, 0, 127, 127);
    for (int i = 0; i < 1024; i++) {
        tarr[i] = 0;
    }
    for (int i = 0; i < 32; i++) {
        writeColorData(tarr, 1024);
    }
    while(1) {
    }
}
