/**
  ******************************************************************************
  * @file    main.c
  * @author  Ac6
  * @version V1.0
  * @date    01-December-2013
  * @brief   Default main function.
  ******************************************************************************
*/


#include "stm32l4xx.h"
#include "stm32l476g_discovery.h"
#include "main.h"

void Error_Handler(void);
void SystemClock_Config(void);

UART_HandleTypeDef UartHandle;
uint8_t buf[2];

int main(void)
{
	uint8_t sbuf[] = "abcd";

	HAL_Init();
	SystemClock_Config();
	//BSP_LED_Init(LED4);
	//BSP_LED_Init(LED5);

	//UartHandle.Instance = USART1;
	UartHandle.Instance        = USARTx;

	  UartHandle.Init.BaudRate   = 9600;
	  UartHandle.Init.WordLength = UART_WORDLENGTH_8B;
	  UartHandle.Init.StopBits   = UART_STOPBITS_1;
	  UartHandle.Init.Parity     = UART_PARITY_NONE;
	  UartHandle.Init.HwFlowCtl  = UART_HWCONTROL_NONE;
	  UartHandle.Init.Mode       = UART_MODE_TX_RX;

	  if (HAL_UART_Init(&UartHandle) != HAL_OK)
	  {
	    /* Initialization Error */
	    Error_Handler();
	  }

	//if (HAL_UART_DeInit(&usart_init) != HAL_OK) {
	//	Error_Handler();
	//}
	//if (HAL_UART_Init(&usart_init) != HAL_OK) {
	//	Error_Handler();
	//}

	//if (HAL_UART_Transmit(&UartHandle, (uint8_t*)sbuf, 4, 5000) != HAL_OK) {
	//	Error_Handler();
	//}z
	//if (HAL_UART_Receive(&UartHandle, (uint8_t*)buf, 1, 0x1fffffff) != HAL_OK) {
	//	Error_Handler();
	//}
	if (HAL_UART_Transmit_DMA(&UartHandle, (uint8_t*)sbuf, 4) != HAL_OK) {
		Error_Handler();
	}
	if (HAL_UART_Receive_IT(&UartHandle, (uint8_t*)buf, 2) != HAL_OK) {
			Error_Handler();
	}

	while(1);
}

void SystemClock_Config(void) {
	  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
	  RCC_OscInitTypeDef RCC_OscInitStruct = {0};

	  /* MSI is enabled after System reset, activate PLL with MSI as source */
	  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_MSI;
	  RCC_OscInitStruct.MSIState = RCC_MSI_ON;
	  RCC_OscInitStruct.MSIClockRange = RCC_MSIRANGE_6;
	  RCC_OscInitStruct.MSICalibrationValue = RCC_MSICALIBRATION_DEFAULT;
	  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
	  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_MSI;
	  RCC_OscInitStruct.PLL.PLLM = 1;
	  RCC_OscInitStruct.PLL.PLLN = 40;
	  RCC_OscInitStruct.PLL.PLLR = 2;
	  RCC_OscInitStruct.PLL.PLLP = 7;
	  RCC_OscInitStruct.PLL.PLLQ = 4;
	  if(HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
	  {
	    /* Initialization Error */
	    while(1);
	  }

	  /* Select PLL as system clock source and configure the HCLK, PCLK1 and PCLK2
	     clocks dividers */
	  RCC_ClkInitStruct.ClockType = (RCC_CLOCKTYPE_SYSCLK | RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2);
	  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
	  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
	  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
	  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;
	  if(HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_4) != HAL_OK)
	  {
	    /* Initialization Error */
	    while(1);
	  }
}

void Error_Handler(void)
{
  /* Turn LED1 on */
  //BSP_LED_On(LED4);
  while(1)
  {
    /* Error if LED1 is slowly blinking (1 sec. period) */
    //BSP_LED_Toggle(LED4);
    HAL_Delay(1000);
  }
}

void HAL_UART_RxCpltCallback(UART_HandleTypeDef * huart) {
	//BSP_LED_On(LED4);
}

void HAL_UART_TxCpltCallback(UART_HandleTypeDef * huart) {
	//BSP_LED_On(LED5);
}

void HAL_UART_ErrorCallback(UART_HandleTypeDef * huart) {
	while(1) {

	}
}

