/**
  ******************************************************************************
  * @file    stm32l4xx_hal_msp_template.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    26-June-2015
  * @brief   HAL MSP module.
  *          This file template is located in the HAL folder and should be copied
  *          to the user folder.
  *
  @verbatim
 ===============================================================================
                     ##### How to use this driver #####
 ===============================================================================
    [..]
    This file is generated automatically by MicroXplorer and eventually modified
    by the user

  @endverbatim
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "stm32l4xx_hal.h"
#include "main.h"

/** @addtogroup STM32L4xx_HAL_Driver
  * @{
  */

/** @defgroup HAL_MSP HAL MSP module driver
  * @brief HAL MSP module.
  * @{
  */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/** @defgroup HAL_MSP_Private_Functions
  * @{
  */

/**
  * @brief  Initialize the Global MSP.
  * @param  None
  * @retval None
  */
//void HAL_MspInit(void)
//{
  /* NOTE : This function is generated automatically by STM32CubeMX and eventually
            modified by the user
   */
//}

/**
  * @brief  DeInitialize the Global MSP.
  * @param  None
  * @retval None
  */
//void HAL_MspDeInit(void)
//{
  /* NOTE : This function is generated automatically by STM32CubeMX and eventually
            modified by the user
   */
//}

/**
  * @brief  Initialize the PPP MSP.
  * @param  None
  * @retval None
  */
void HAL_UART_MspInit(UART_HandleTypeDef * usart)
{
	static DMA_HandleTypeDef hdma_tx;
	static DMA_HandleTypeDef hdma_rx;

	  GPIO_InitTypeDef  GPIO_InitStruct;

	  /*##-1- Enable peripherals and GPIO Clocks #################################*/
	  /* Enable GPIO TX/RX clock */
	  USARTx_TX_GPIO_CLK_ENABLE();
	  USARTx_RX_GPIO_CLK_ENABLE();


	  /* Enable USARTx clock */
	  USARTx_CLK_ENABLE();

	  __HAL_RCC_DMA1_CLK_ENABLE();

	  /*##-2- Configure peripheral GPIO ##########################################*/
	  /* UART TX GPIO pin configuration  */
	  GPIO_InitStruct.Pin       = USARTx_TX_PIN;
	  GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
	  GPIO_InitStruct.Pull      = GPIO_PULLUP;
	  GPIO_InitStruct.Speed     = GPIO_SPEED_HIGH;
	  GPIO_InitStruct.Alternate = USARTx_TX_AF;

	  HAL_GPIO_Init(USARTx_TX_GPIO_PORT, &GPIO_InitStruct);

	  /* UART RX GPIO pin configuration  */
	  GPIO_InitStruct.Pin = USARTx_RX_PIN;
	  GPIO_InitStruct.Alternate = USARTx_RX_AF;

	  HAL_GPIO_Init(USARTx_RX_GPIO_PORT, &GPIO_InitStruct);

	  hdma_tx.Instance = DMA1_Channel4;
	  hdma_tx.Init.Direction = DMA_MEMORY_TO_PERIPH;
	  hdma_tx.Init.MemDataAlignment = DMA_MDATAALIGN_BYTE;
	  hdma_tx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
	  hdma_tx.Init.MemInc = DMA_MINC_ENABLE;
	  hdma_tx.Init.PeriphInc = DMA_PINC_DISABLE;
	  hdma_tx.Init.Mode = DMA_NORMAL;
	  hdma_tx.Init.Priority = DMA_PRIORITY_LOW;
	  hdma_tx.Init.Request = DMA_REQUEST_2;

	  HAL_DMA_Init(&hdma_tx);

	  hdma_rx.Instance = DMA1_Channel5;
	  hdma_rx.Init.Direction = DMA_PERIPH_TO_MEMORY;
	  hdma_rx.Init.MemDataAlignment = DMA_MDATAALIGN_BYTE;
	  hdma_rx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
	  hdma_rx.Init.MemInc = DMA_MINC_ENABLE;
	  hdma_rx.Init.PeriphInc = DMA_PINC_DISABLE;
	  hdma_rx.Init.Mode = DMA_NORMAL;
	  hdma_rx.Init.Priority = DMA_PRIORITY_LOW;
	  hdma_rx.Init.Request = DMA_REQUEST_2;

	  HAL_DMA_Init(&hdma_rx);

	  __HAL_LINKDMA(usart, hdmatx, hdma_tx);
	  //__HAL_LINKDMA(usart, hdmarx, hdma_rx);

	  HAL_NVIC_SetPriority(USART1_IRQn, 1, 1);
	  HAL_NVIC_EnableIRQ(USART1_IRQn);

	  HAL_NVIC_SetPriority(DMA1_Channel4_IRQn, 2, 2);
	  HAL_NVIC_EnableIRQ(DMA1_Channel4_IRQn);

	  //HAL_NVIC_SetPriority(DMA1_Channel5_IRQn, 1, 1);
	  //HAL_NVIC_EnableIRQ(DMA1_Channel5_IRQn);
}

/**
  * @brief  DeInitialize the PPP MSP.
  * @param  None
  * @retval None
  */
void HAL_UART_MspDeInit(UART_HandleTypeDef *husart)
{
  HAL_GPIO_DeInit(GPIOA, GPIO_PIN_2);
  HAL_GPIO_DeInit(GPIOA, GPIO_PIN_3);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/

