#include "mbed.h"
#include "LoopTicker.hpp"

LoopTicker::LoopTicker()
{
    fptr = NULL;
    time = 0.0f;
    updated = false;
}

void LoopTicker::attach(void (*fptr_)(), float time_)
{
    fptr = fptr_;
    time = time_;
    ticker_.attach(this, &LoopTicker::interrupt, time);
}

void LoopTicker::detach()
{
    fptr = NULL;
    time = 0.0f;
    updated = false;
    ticker_.detach();
}

void LoopTicker::loop()
{
    if (updated)
    {
        fptr();
        updated = false;
    }
}

void LoopTicker::interrupt()
{
    updated = true;
}