#ifndef __GYSFDMAXB_HPP__
#define __GYSFDMAXB_HPP__

#include "mbed.h"
#include "Vector3.hpp"

/*
$GPZDA,030049.971,06,04,2021,,*54
$GPGGA,030050.971,,,,,0,0,,,M,,M,,*41
$GPGLL,,,,,030050.971,V,N*73
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPGSV,1,1,00*79
$GPRMC,030050.971,V,,,,,0.00,0.00,060421,,,N*45
$GPVTG,0.00,T,,M,0.00,N,0.00,K,N*32
$GPZDA,030050.971,06,04,2021,,*5C
$GPGGA,030051.971,,,,,0,0,,,M,,M,,*40
$GPGLL,,,,,030051.971,V,N*72
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPGSV,1,1,00*79
$GPRMC,030051.971,V,,,,,0.00,0.00,060421,,,N*44
$GPVTG,0.00,T,,M,0.00,N,0.00,K,N*32
$GPZDA,030051.971,06,04,2021,,*5D
*/

#define start_size 32
#define uart_size 2048
#define Radius 6378136.6f

class GYSFDMAXB
{
private:
//    Serial serial;
    BufferedSerial serial;
    volatile bool receive_flag;
    char* uart_start[start_size];
    volatile int start_index;
    char uart_buffer[uart_size];
    volatile int uart_index;
    Ticker timer;
    
    void Receive();
    void Punctuate();
    
public:
    // GPGGA
    
    int Quality;
    int Satellites;
    float HDOP;
    float Elevation;
    char UnitElevation;
    float GeoidElevation;
    char UnitGeoidElevation;
    
    // GPRMC
    int Hours;
    int Minutes;
    int Seconds;
    int Milliseconds;
    char Status;
    float Latitude;
    char N_S;
    float Longitude;
    char E_W;
    float Speed;
    float Direction;
    int Day;
    int Month;
    int Year;
    float GeomagneticDeclination ;
    char GeomagneticE_W; 
    char Mode;
    
    Vector3 UniversalZeroPosition;
    Vector3 UniversalZeroUnitN;
    Vector3 UniversalZeroUnitE;
    Vector3 UniversalZeroUnitD;
    Vector3 UniversalPosition;
    Vector3 Position;

    GYSFDMAXB(PinName tx, PinName rx);
    void Update();
    void Initialize();
    Vector3 ToUniversalUnit();
    Vector3 ToUniversal();
    void CalcurateUnit();
    void Calcurate();
    Vector3 Calcurate(Vector3 position);
};

#endif