#ifndef __GYSFDMAXB_HPP__
#define __GYSFDMAXB_HPP__

#include "mbed.h"
#include "Vector3.hpp"

/*
$GPZDA,030049.971,06,04,2021,,*54
$GPGGA,030050.971,,,,,0,0,,,M,,M,,*41
$GPGLL,,,,,030050.971,V,N*73
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPGSV,1,1,00*79
$GPRMC,030050.971,V,,,,,0.00,0.00,060421,,,N*45
$GPVTG,0.00,T,,M,0.00,N,0.00,K,N*32
$GPZDA,030050.971,06,04,2021,,*5C
$GPGGA,030051.971,,,,,0,0,,,M,,M,,*40
$GPGLL,,,,,030051.971,V,N*72
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPGSV,1,1,00*79
$GPRMC,030051.971,V,,,,,0.00,0.00,060421,,,N*44
$GPVTG,0.00,T,,M,0.00,N,0.00,K,N*32
$GPZDA,030051.971,06,04,2021,,*5D
*/


class GYSFDMAXB
{
private:
    Serial serial;
    volatile bool receive_flag;
    const int start_size = 32;
    char* uart_start[start_size];
    volatile int start_index;
    const int uart_size = 4096;
    char uart_buffer[uart_size];
    volatile int uart_index;
    Ticker timer;
    
    static const float Radius = 6378136.6f;
    
    void Receive();
    void Punctuate();
    
public:
    // GPGGA
    volatile int Quality;
    volatile int Satellites;
    volatile float HDOP;
    volatile float Elevation;
    volatile char UnitElevation;
    volatile float GeoidElevation;
    volatile char UnitGeoidElevation;
    
    // GPRMC
    volatile int Hours;
    volatile int Minutes;
    volatile int Seconds;
    volatile int Milliseconds;
    volatile char Status;
    volatile float Latitude;
    volatile char N_S;
    volatile float Longitude;
    volatile char E_W;
    volatile float Speed;
    volatile float Direction;
    volatile int Day;
    volatile int Month;
    volatile int Year;
    volatile float GeomagneticDeclination ;
    volatile char GeomagneticE_W; 
    volatile char Mode;
    
    Vector3 UniversalZeroPosition;
    Vector3 UniversalZeroUnitN;
    Vector3 UniversalZeroUnitE;
    Vector3 UniversalZeroUnitD;
    Vector3 UniversalPosition;
    Vector3 Position;

    GYSFDMAXB(PinName tx, PinName rx);
    void Update();
    void Initialize();
    Vector3 ToUniversalUnit();
    Vector3 ToUniversal();
    void CalcurateUnit();
    void Calcurate();
    Vector3 Calcurate(Vector3 position);
};

#endif