#include "mbed.h"
#include "uLCD_4DGL.h"
#include "motordriver.h"
#include "PinDetect.h"
#include "rtos.h"
#include "ReceiverIR.h"

uLCD_4DGL lcd(p28, p27, p29); // LCD screen
Mutex stdio_mutex; // Mutex for LCD

DigitalIn pb(p7); //LCD menu Pushbuttons
DigitalIn pb1(p10); 
DigitalIn pb2(p13); 
DigitalIn pb3(p16); 
PinDetect pb8(p8); // Pushbutton to start motors

AnalogIn IRout(p20); // IR Module (front sensor)

Motor left(p21,p22,p23,1);
Motor right(p26,p25,p24,1);

ReceiverIR ir_rx(p15); // IR receiver
RemoteIR::Format format;

DigitalOut led1(LED1); //LED1 used for debugging purposes
DigitalOut led2(LED2);
//Timer t; //Timer used to calculate automated driving distance

//Globals
bool OnOff = false; //turn motors on/off
uint8_t buf[32];
int bitcount;
uint8_t dat; //used to Identify button pressed on Universal remote

// push button hit callback to start/stop motor immediately
void pb8_hit_callback (void) { 
    OnOff = !OnOff;   
}

void display_binary(uint8_t *buf, uint8_t cnt){
    dat = *(buf + 2);
    printf("%02x",dat);
    printf("\n\r");
}

// IR module in front of robot, stop motors if object detected
void IRmod(void const *args){
    while(1){
        if(IRout > 0.35f ){
            OnOff = false;
            led2 = 1;
        }   
        else{
            //OnOff = false;
            led2 = 0;
        }
    }
}

// Motor manual control using IR Receiver with Universal Remote
void IRrec(void const *args){
    while(1){
        if(OnOff == false){
            if (ir_rx.getState() == ReceiverIR::Received) {
                bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
                dat = ((bitcount + 7) / 8);
                dat = *(buf + 2);
                printf("%02x\n\r",dat);
                switch (dat){
                    case 0x01:
                        left.speed(0.8);
                        right.speed(0.8);
                        wait(0.001);
                        break;
                    case 0x03:
                        left.speed(0.8);
                        right.speed(-0.8);
                        wait(0.001);
                        break;
                    case 0x05:
                        left.speed(-0.8);
                        right.speed(0.8);
                        wait(0.001);
                        break;
                    case 0x07:
                        left.speed(-0.8);
                        right.speed(-0.8);
                        wait(0.001);
                        break;
                    case 0x00: // End manual override, return to automated route
                        left.stop(1);
                        right.stop(1);
                        OnOff = true;
                        break;
                }
            }
            else if (ir_rx.getState() == ReceiverIR::Receiving){
                switch (dat){
                    case 0x01:
                        left.speed(0.8);
                        right.speed(0.8);
                        wait(0.001);
                        break;
                    case 0x03:
                        left.speed(-0.6);
                        right.speed(0.6);
                        wait(0.001);
                        break;
                    case 0x05:
                        left.speed(0.6);
                        right.speed(-0.6);
                        wait(0.001);
                        break;
                    case 0x07:
                        left.speed(-0.8);
                        right.speed(-0.8);
                        wait(0.001);
                        break;
                    case 0x00: // End manual override, return to automated route
                        left.stop(1);
                        right.stop(1);
                        OnOff = true;
                        break;
                }
            }
            else if (ir_rx.getState() == ReceiverIR::Idle) {
                wait(0.1);
                if(ir_rx.getState() == ReceiverIR::Idle){
                    left.stop(1);
                    right.stop(1);
                    wait(0.001);
                }
            }
        }
    }   
}

void rightTurn(){  //Turn bot 90 degrees right
    left.speed(-0.6);
    right.speed(0.6);
    wait(0.5);
    left.stop(1);
    right.stop(1);
}

void moveAhead(float length){
    Timer t;
    t.start();
    while(t.read() < length){
        if(OnOff == true){
            left.speed(0.8);
            right.speed(0.8);
        }
        else{
            left.stop(1);
            right.stop(1);
        }
    }
    left.stop(1);
    right.stop(1);
    t.stop();   
}

int main() {
    led1 = 0;
    Thread thread1(IRmod); // Create IRmod thread
    Thread thread3(IRrec); // Create IR receiver thread for manual motor control
    
    lcd.baudrate(3000000); // Set LCD baud rate
    lcd.background_color(0);
    lcd.cls(); // clear LCD screen
    
    pb8.mode(PullUp); //internal pullup for push button 8
    wait(0.001); // initial delay for pullup
    pb8.attach_deasserted(&pb8_hit_callback); // Setup pb interrupt callback func
    pb8.setSampleFrequency(); //Start sampling pb input using interrupt
    
    pb.mode(PullUp); //Intitial Pusbutton Setup
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    wait(.001);
    
    // Initial LCD menu setup
    /*
    stdio_mutex.lock();
    lcd.locate(1,2); 
    lcd.printf("Add Stop<");
    lcd.locate(1,4);
    lcd.printf("Remove Stop ");
    lcd.locate(1,6);
    lcd.printf("Exit ");
    stdio_mutex.unlock();
    */
    int stop = 1; // counter for which Bus Stop the bot is at
    bool running = 1; //alternates between moving or stopping
    
    //bool count = false;
    //int old_pb=1;
    //int new_pb;
    
    //int count1=0;
    //int old_pb1=1;
    //int new_pb1;
    
    //int old_pb2=1;
    //int new_pb2;
    
    //bool count3 = false; //whether enter has been pressed
    //bool count4 = true; //whether it is currently on add stops or remove stops
    //int old_pb3=1;
    //int new_pb3;
    //bool Menu = false;
    
 //Set up the booleans determining which stops are currently being serviced
   // bool stop1 = true;
   // bool stop2 = true;
    //bool stop3 = true;
    //bool stop4 = true;
    
    //bool running = true;
    //int stop = 1;
    
    while(1) {
        
        if(OnOff == true){ //Keeps Led1 in same state as OnOff (for debugging)
            led1 = 1;
        }
        else{
            led1 = 0;
        }
        
        if(OnOff == true){
            if(running && stop == 1){ // Moving to bus stop 1
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop 1");
                stdio_mutex.unlock();
                moveAhead(2); // Move forward 1.5 seconds
                running = !running;
            }
            else if(!running && stop == 1){ // Stopped at bus stop 1
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop 1");
                stdio_mutex.unlock();
                Thread::wait(5000); // Wait 5 seconds at Bus Stop
                rightTurn(); // 90 degree right turn
                running = !running;
                stop++;
            }
            else if(running && stop == 2){ //moving to bus stop 2
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop 2");
                stdio_mutex.unlock();
                moveAhead(1.5); // Move forward for 1 second
                running = !running;
            }
            else if(!running && stop == 2){ // Stopped at bus stop 2
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop 2");
                stdio_mutex.unlock();
                Thread::wait(5000);
                rightTurn();
                running = !running;
                stop++;
            }
            else if(running && stop == 3){ // moving to bus stop 3
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop 3");
                stdio_mutex.unlock();
                moveAhead(2);
                running = !running;
            }
            else if(!running && stop == 3){ // stopped at bus stop 3
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop 3");
                stdio_mutex.unlock();
                Thread::wait(5000);
                rightTurn();
                running = !running;
                stop++;
            }
            else if(running && stop == 4){ // moving to bus stop 4
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop 4");
                stdio_mutex.unlock();
                moveAhead(1.5);
                running = !running;
            }
            else if(!running && stop == 4){ // stopped at bus stop 4
                stdio_mutex.lock();
                lcd.cls();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop 4");
                stdio_mutex.unlock();
                Thread::wait(5000);
                rightTurn();
                running = !running;
                stop = 1; // reset back to start
            }
        }

        //new_pb = pb;
        //new_pb1 = pb1;
        //new_pb2 = pb2;
        //new_pb3 = pb3;
        
        
        
        /* LCD Add/Remove Bus Stop Functionality
        // If NOT currently in "Menu" mode (motor running)
        if(!Menu && OnOff == true) {
            if(running && stop == 1){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop1 ");  // move motors to stop 1  4 feet frwrd
                stdio_mutex.unlock();
                moveAhead(1); // move 4 seconds
                running = !running;
            }
            else if(!running && stop == 1){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop1");   // stop motors 5 seconds
                stdio_mutex.unlock();
                //Thread::wait(5000); // 5 second wait
                rightTurn();
                running = !running;
                stop++;
            }
            else if(running && stop == 2){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop2 ");    // move to stop 2. 90 deg right turn + forward 3 feet
                stdio_mutex.unlock();
            }
            else if(!running && stop == 2){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop2");   
                stdio_mutex.unlock(); 
            }
            else if(running && stop == 3){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop3");    
                stdio_mutex.unlock();
            }
            else if(!running && stop == 3){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop3");   
                stdio_mutex.unlock(); 
            }
            else if(running && stop == 4){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Moving to Stop4 "); 
                stdio_mutex.unlock();   
            }
            else if(!running && stop == 4){
                stdio_mutex.lock();
                lcd.locate(1,5);
                lcd.printf("Waiting at Stop4");    
                stdio_mutex.unlock();
            }
        }        
        else if(Menu) { //All of the below runs the menu interactions
        
            if ((new_pb==0) && (old_pb==1)) count = !count;
            if ((new_pb1==0) && (old_pb1==1) && count1 < 3) count1++;
            if ((new_pb2==0) && (old_pb2==1) && count1 > 0) count1--;
            if ((new_pb3==0) && (old_pb3==1)) {
                count3 = !count3;
                lcd.cls();
                count1 = 0;
            }
        
            if(count && !count3){
                lcd.cls();
                count1 = 0;
                count = false;
            }
        
            if(count && count3 && count4){
                if(count1 == 0) stop1 = true;
                if(count1 == 1) stop2 = true;
                if(count1 == 2) stop3 = true;
                if(count3 == 3) stop4 = true;
                count = false;
            }
        
            if(count && count3 && count4){
                if(count1 == 0) stop1 = false;
                if(count1 == 1) stop2 = false;
                if(count1 == 2) stop3 = false;
                if(count3 == 3) stop4 = false;
                count = false;
            }
        
            if(!count) {
            if(!count3) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("             ");
                stdio_mutex.unlock();
            }

            if(count3 && count4 && count1==0) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Add stops");
                lcd.locate(1,2); //Initial Menu Setup for adding stops
                lcd.printf("Stop 1<        ");
                lcd.locate(1,4);
                lcd.printf("Stop 2         ");
                lcd.locate(1,6);
                lcd.printf("Stop 3 ");
                lcd.locate(1,8);
                lcd.printf("Stop 4 ");
                stdio_mutex.unlock();
            }
            if(count3 && count4 && count1==1) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Add stops");
                lcd.locate(1,2); //Initial Menu Setup for adding stops
                lcd.printf("Stop 1         ");
                lcd.locate(1,4);
                lcd.printf("Stop 2<        ");
                lcd.locate(1,6);
                lcd.printf("Stop 3 ");
                lcd.locate(1,8);
                lcd.printf("Stop 4 ");
                stdio_mutex.unlock();
            }
            if(count3 && count4 && count1==2) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Add stops");
                lcd.locate(1,2); //Initial Menu Setup for adding stops
                lcd.printf("Stop 1         ");
                lcd.locate(1,4);
                lcd.printf("Stop 2         ");
                lcd.locate(1,6);
                lcd.printf("Stop 3<");
                lcd.locate(1,8);
                lcd.printf("Stop 4 ");
                stdio_mutex.unlock();
            }
            if(count3 && count4 && count1==3) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Add stops");
                lcd.locate(1,2); //Initial Menu Setup for adding stops
                lcd.printf("Stop 1         ");
                lcd.locate(1,4);
                lcd.printf("Stop 2         ");
                lcd.locate(1,6);
                lcd.printf("Stop 3 ");
                lcd.locate(1,8);
                lcd.printf("Stop 4<");
                stdio_mutex.unlock();
            }
            
            if(count3 && !count4 && count1 == 0) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Remove Stops");
                lcd.locate(1,2); //Initial Menu Setup for removing
                lcd.printf("Stop 1<        ");
                lcd.locate(1,4);
                lcd.printf("Stop 2         ");
                lcd.locate(1,6);
                lcd.printf("Stop 3 ");
                lcd.locate(1,8);
                lcd.printf("Stop 4 ");
                stdio_mutex.unlock();
            }
            if(count3 && !count4 && count1 == 1) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Remove Stops");
                lcd.locate(1,2); //Initial Menu Setup for removing
                lcd.printf("Stop 1         ");
                lcd.locate(1,4);
                lcd.printf("Stop 2<        ");
                lcd.locate(1,6);
                lcd.printf("Stop 3 ");
                lcd.locate(1,8);
                lcd.printf("Stop 4 ");
                stdio_mutex.unlock();
            }
            if(count3 && !count4 && count1 == 2) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Remove Stops");
                lcd.locate(1,2); //Initial Menu Setup for removing
                lcd.printf("Stop 1         ");
                lcd.locate(1,4);
                lcd.printf("Stop 2         ");
                lcd.locate(1,6);
                lcd.printf("Stop 3<");
                lcd.locate(1,8);
                lcd.printf("Stop 4 ");
                stdio_mutex.unlock();
            }if(count3 && !count4 && count1 == 3) {
                stdio_mutex.lock();
                lcd.locate(1,1);
                lcd.printf("Remove Stops");
                lcd.locate(1,2); //Initial Menu Setup for removing
                lcd.printf("Stop 1         ");
                lcd.locate(1,4);
                lcd.printf("Stop 2         ");
                lcd.locate(1,6);
                lcd.printf("Stop 3 ");
                lcd.locate(1,8);
                lcd.printf("Stop 4<");
                stdio_mutex.unlock();
            }
            if(count1 == 0 && !count3) {
                stdio_mutex.lock();
                lcd.locate(1,2); //Initial Menu Setup
                lcd.printf("Add Stop<"); 
                stdio_mutex.unlock();
                count4 = true;   
            } if(count1 != 0 && !count3) {
                stdio_mutex.lock();
                lcd.locate(1,2); //Initial Menu Setup
                lcd.printf("Add Stop ");
                stdio_mutex.unlock();
            }
            
            if(count1 == 1 && !count3) {
                stdio_mutex.lock();
                lcd.locate(1,4);
                lcd.printf("Remove Stop<");  
                stdio_mutex.unlock(); 
                count4 = false; 
            } if(count1 != 1 && !count3) {
                stdio_mutex.lock();
                lcd.locate(1,4);
                lcd.printf("Remove Stop ");
                stdio_mutex.unlock();
            }
            
            if(count1 == 2 && !count3) {
                stdio_mutex.lock();
                lcd.locate(1,6);
                lcd.printf("Exit<");   
                stdio_mutex.unlock(); 
            } if(count1 != 2 && !count3) {
                stdio_mutex.lock();
                lcd.locate(1,6);
                lcd.printf("Exit ");
                stdio_mutex.unlock();
            }
            }
            }
        
        
        old_pb = new_pb;
        old_pb1 = new_pb1;
        old_pb2 = new_pb2;
        old_pb3 = new_pb3; */
    }
}
