#include "mbed.h"
#include "rtos.h"

#include "uLCD_4DGL.h" // uLCD
#include "wave_player.h" // Speaker
#include "SDFileSystem.h" // SD card
#include <mpr121.h> // Touchpad


bool ArmedOnOff; // Global variable to Arm the alarm;
int CurrentKey; // Global variable to display the current key value to the LCD
int OldCurrentKey;
int KeyCount = 0; //Keeps track of how many times in a row the key has been pressed
int Trigger = 1; //Determining if the alarm has been triggered
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int num1; //The four digits of the passcode
int num2;
int num3;
int num4;

int Safety = 0; //Counter to check if correct passcode is entered


SDFileSystem sd(p5, p6, p7, p8, "sd"); // MicroSD card

AnalogIn IRout(p20); // IR Module

AnalogOut DACout(p18); // Speaker / Wave Player
wave_player waver(&DACout); // Speaker / Wave player

uLCD_4DGL uLCD(p28, p27, p29); // used to create LCD object

Mutex stdio_mutex; // Mutex for LCD thread
 
InterruptIn interrupt(p26); // Create interrupt receiver object on pin 26
 
I2C i2c(p9, p10); // Setup i2c bus on pins 9 and 10
 
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS); // Mpr121 constructor

// mpr121 keypad interrupt
void fallInterrupt(){
    OldCurrentKey = CurrentKey;
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    i=0;
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
    if(led1==0 & led2==0 & led3==0 & led4==1) //Convert recieved value from keypad
        CurrentKey = 0;
    if(led1==0 & led2==0 & led3==1 & led4==0)
        CurrentKey = 1;
    if(led1==0 & led2==0 & led3==1 & led4==1)
        CurrentKey = 2;
    if(led1==0 & led2==1 & led3==0 & led4==0)
        CurrentKey = 3;
    if(led1==0 & led2==1 & led3==0 & led4==1)
        CurrentKey = 4;
    if(led1==0 & led2==1 & led3==1 & led4==0)
        CurrentKey = 5;
    if(led1==0 & led2==1 & led3==1 & led4==1)
        CurrentKey = 6;
    if(led1==1 & led2==0 & led3==0 & led4==0)
        CurrentKey = 7;
    if(led1==1 & led2==0 & led3==0 & led4==1)
        CurrentKey = 8;
    if(led1==1 & led2==0 & led3==1 & led4==0)
        CurrentKey = 9;
    if(led1==1 & led2==0 & led3==1 & led4==1)
        CurrentKey = 10;
    if(led1==1 & led2==1 & led3==0 & led4==0)
        CurrentKey = 11;
    if(CurrentKey != OldCurrentKey & Trigger  == 1){ //Ensures that only four numbers are used at a time
        KeyCount = KeyCount + 1;
        if(KeyCount == 1)
            num1 = CurrentKey;
        if(KeyCount == 2)
            num2 = CurrentKey;
        if(KeyCount == 3)
            num3 = CurrentKey;
        if(KeyCount == 4){
            num4 = CurrentKey;
            Trigger = 0;
            KeyCount = 0;
        }
    }
}


// uLCD thread
void Armed(void const *args){ //Thread for initial state of the alarm
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    while(1){
        if(Safety == 0){
            stdio_mutex.lock();  // Mutex lock for LCD screen
            if(!ArmedOnOff){
                uLCD.locate(1,1); //The default state for the alarm
                uLCD.printf("ALARM: ARMED   ");
                uLCD.locate(1,5);
                uLCD.printf("Enter Passcode: ");
            }
            stdio_mutex.unlock(); // Unlock mutex
        }
    }
}

void PassCode(void const *args){ //Thread to check passcode
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    while(1){
        if(Trigger == 0){
            stdio_mutex.lock();  // Mutex lock for LCD screen
            uLCD.locate(1,7);
            uLCD.printf("                     ");
            uLCD.locate(1,8);
            uLCD.printf("                     ");
            if(num1 == 1 & num2 == 9 & num3 == 4 & num4 == 2){ //Checks to see if the correct key is entered, 1942
                uLCD.locate(1,1);
                uLCD.printf("ALARM: DISARMED"); //The disarmed state for the alarm upon entering the correct code
                uLCD.locate(1,7);
                uLCD.printf("%d %d %d %d",num1,num2,num3,num4);
                uLCD.locate(1,8);
                uLCD.printf("Take your item");
                Safety = 1;
                int countDown = 20;
                while(countDown >=0){ // Countdown to when the alarm will re-arm
                    uLCD.locate(1,9);
                    uLCD.printf("ARMING IN %d     ", countDown);
                    countDown--;
                    Thread::wait(1000.0); // Wait 1 second
                }
                countDown = 20;
                uLCD.locate(1,9);
                uLCD.printf("                 "); //clears the lower screen
                uLCD.locate(1,7);
                uLCD.printf("           ");
                uLCD.locate(1,8);
                uLCD.printf("              ");
                Safety = 0;
            }
            else {
                uLCD.locate(1,7);
                uLCD.printf("%d %d %d %d",num1,num2,num3,num4); //Displays the incorrect passcode waits 5 seconds for further entries
                uLCD.locate(1,8);
                uLCD.printf("INCORRECT");
                Thread::wait(5000.0);
                uLCD.locate(1,7);
                uLCD.printf("           "); //clears the lower screen
                uLCD.locate(1,8);
                uLCD.printf("          ");
            }
            stdio_mutex.unlock(); // Unlock mutex
            Trigger = 1;
            Thread::wait(1000.0); // 10 second wait
        }
    }
}


void Alarm(void const *args) //Thread to sound alarm
{
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    while(1){
        if(ArmedOnOff==true & Safety == 0){
            stdio_mutex.lock();  // Mutex lock for LCD screen
            uLCD.locate(1,1);
            uLCD.printf("ALARM: MISSING!"); //Sounds alarm if the correct code isn't entered and the object is missing
            uLCD.locate(1,5);
            uLCD.printf("Enter Passcode: ");
            stdio_mutex.unlock(); // Unlock mutex
            FILE *wave_file;
            wave_file=fopen("/sd/myMusic/Alarm.wav","r");
            waver.play(wave_file);
            fclose(wave_file);

            //Thread::wait(1000.0); // Wait 1 second
        }
    }
}


int main(){
    Thread thread1(Alarm);
    Thread thread3(Armed);
    Thread thread4(PassCode);
    interrupt.mode(PullUp);
    interrupt.fall(&fallInterrupt);
    
    while(1){
            

        if (IRout < 0.5f){
            //led1 = 1;
            ArmedOnOff = true;
        }
        else {
            ArmedOnOff = false;
        }

    }
}