#include "mbed.h"
#include "tsi_sensor.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

#define ESPERAR_A 300
#define MOSTRAR 301
#define ESPERO_JUG 302
#define MUESTREO 303
#define ESPERAR_B 304
#define ESPERAR_C 305
#define JUGANDO 306
#define GEN_SEC 307

// Salidas
DigitalOut ledr(LED1);
DigitalOut ledg(LED2);
DigitalOut ledb(LED3);

// Funciones
void GENERAL();
void MOSTRAR_LED();
void JUEGO();
void PULSADORES();
void t();

// Timer
Ticker timer;

// Variables
int secuencia[20], variable=0;
int cant=0, finsec=0, n=0, P1=0, P2=0, P3=0;
int habmostrar=0,  habjug=0, fin_mostrar=0, finjug=0, perdiste=0;
volatile unsigned int tiempo=100;
static int traba=0, principio=0;

// Entradas
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

int main()
{
    ledr=1;
    ledb=1;
    ledg=1;
    timer.attach(&t,0.01);
    while(1) {
        variable++;  // SEMILLA
        GENERAL();
        MOSTRAR_LED();
        JUEGO();
        PULSADORES();
    }
}


void GENERAL()  // Maquina de estados: funcionamiento general del programa
{
    static int paso_a=ESPERAR_A;
    switch(paso_a) {
        case ESPERAR_A:     // RESET
            habmostrar=0;
            habjug=0;
            fin_mostrar=0;
            finjug=0;
            perdiste=0;
            cant=0;
            principio=0;
            if((P1 == 1 || P2 == 1 || P3 == 1) && traba == 0) { // Con que el TSI detecte algo alcanza para comenzar el juego
                traba=1;
                paso_a=GEN_SEC;
                principio++;
                printf("Inicio del juego\n\r");
            }
            break;
        case GEN_SEC:    // Genero una secuencia aleatoria
        srand(variable);
        secuencia[cant]=(rand() % 3);
        paso_a=MOSTRAR;
        break;
        case MOSTRAR:      // Habilito la maquina de estados de muestreo
            habmostrar=1;
            finjug=0;
            if(fin_mostrar==1) {
                paso_a=ESPERO_JUG;
            }
            break;
        case ESPERO_JUG:  // Habilito la maquina de estados de juego
            habjug=1;
            fin_mostrar=0;
            if(finjug==1) { // Si se levanto el flag de final de jugada incremento el nivel
                cant++;
                if(cant == 24){     // Si el juego llega al nivel 24 termina
                    printf("Ganaste!\n\r");
                    paso_a=ESPERAR_A;
                    }
                else
                    paso_a=GEN_SEC;
            }
            if(perdiste==1) {   // Si se levanta el flag de partida perdida reinicio el juego
                paso_a=ESPERAR_A;
            }
            break;
    }
}


void MOSTRAR_LED()    // Maquina de estados: muestreo de la secuencia de leds a seguir
{
    static int paso_b=ESPERAR_B;
    switch(paso_b) {
        case ESPERAR_B:
            if(habmostrar==1) {
                paso_b=MUESTREO;
            }
            break;
        case MUESTREO:  
            if(finsec==0) {  // Muestra un valor n de la secuencia un determinado tiempo, se apaga un determinado tiempo e incrementa n
                if (tiempo == 0) {
                    if(cant < n) {
                        finsec=1;
                    } else if(secuencia[n]== 0) {
                        ledr=0;
                        ledg=1;
                        ledb=1;
                        printf("LED_ROJO\n\r");
                    } else if(secuencia[n]== 1) {
                        ledr=1;
                        ledg=0;
                        ledb=1;
                        printf("LED_VERDE\n\r");
                    } else if(secuencia[n]== 2) {
                        ledr=1;
                        ledg=1;
                        ledb=0;
                        printf("LED_AZUL\n\r");
                    }
                    tiempo = 130;
                    n++;
                }
                if(tiempo == 40) { // Se apaga un determinado tiempo para diferenciar en caso de ser dos veces el mismo color
                    ledr=1;
                    ledg=1;
                    ledb=1;
                }
            } else if(finsec==1) {  // Muestreo finalizado
                ledr=1;
                ledg=1;
                ledb=1;
                fin_mostrar=1;
                habmostrar=0;
                paso_b=ESPERAR_B;
            }
            break;
    }
}


void JUEGO()    // Maquina de estados: se compara lo que presiona el jugador con la secuencia generada
{
    static int paso_c=ESPERAR_C;
    switch(paso_c) {
        case ESPERAR_C:
            if(habjug==1) {
                paso_c=JUGANDO;
                n=0;
                finsec=0;
            }
            break;
        case JUGANDO:
            if(finsec == 0) {
                if((P1 == 1 || P2 == 1 || P3 == 1) && traba == 0) { // Se espera a que se presione el TSI para no comparar todo el tiempo
                    traba=1;
                    if((secuencia[n] == 0 && P1 == 1) || (secuencia[n] == 1 && P2 == 1) || (secuencia[n] == 2 && P3 == 1)) { // Comparo lo que se presiono con la secuencia
                        n++;    // Si coincide incremento
                    } else {    // Si difiere levanto el flag de partida perdida
                        printf("Game Over\n\r");
                        perdiste=1;
                        principio=0;
                        habjug=0;
                        break;
                    }
                    if(cant < n) {  // Si termino la secuencia y todas las comparaciones fueron coincidentes levanto el flag de final de secuencia
                        finsec=1;
                        printf("Enhorabuena!\n\r");
                    }
                }
            } else if(finsec == 1) {    // Si se levanto el flag de final de secuencia levanto el flag de final de jugada
                finjug=1;
                habjug=0;
                paso_c=ESPERAR_C;
            }
            break;

    }
}


void t()
{
    if (tiempo > 0)
        tiempo--;
}


void PULSADORES()   // Separacion del TSI en pulsadores
{
    static int lectura=0, color=0;
    float valor=tsi.readPercentage();   // Leo el TSI una vez y lo guardo en una variable para no leerlo reiteradas veces
    if(tiempo == 0) {
        tiempo=3;                   // Tiempo de retardo para no leer todo el tiempo
        if(valor != 0 && lectura == 0) {  // la variable lectura se encarga de detectar el flanco para no leer distintos valores de un mismo pulso
            lectura=1;
            if(valor > 0.37 && valor < 0.73) {
                P2=1;
            } else if(valor <= 0.33) {
                P1=1;
            } else if(valor >= 0.77) {
                P3=1;
            }
        } else if( valor == 0 && lectura == 1) {
            ledr=1;
            ledg=1;
            ledb=1;
            traba=0;
            color=0;
            lectura=0;
            P1=0;
            P2=0;
            P3=0;
        }
        if(valor != 0 && principio > 0 && color == 0) {
            color=1;
            if(valor > 0.37 && valor < 0.73) {
                printf("Tocaste el color VERDE\n\r");
                ledg=0;
            } else if(valor <= 0.33) {
                printf("Tocaste el color ROJO\n\r");
                ledr=0;
            } else if(valor >= 0.77) {
                printf("Tocaste el color AZUL\n\r");
                ledb=0;
            }
        }
    }
}