#include "mbed.h"
#include "tsi_sensor.h"
#include "Dht11.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

#define ESPERO_ARRANQUE 0
#define MODO_A 1
#define MODO_C 2
#define LEO_TEMP 3
#define CALC_RPM 4
#define COMPARO 5
#define DESHABILITADO_A 6
#define RECTA 8
#define DESHABILITADO_C 9

//Timer
Timeout velocidad;
Timeout temperatura;

// Funciones
void modo();
void lazo_cerrado();
void lazo_abierto();
void sensado_temp();
void calculo_vel_la();
void calculo_vel_lc();
void lectura_tsi();

// Variables
unsigned int variacion_tsi=0, hab_modo_a=0, hab_modo_c=0, rpm=0, alto=0, hab_sens_temp=0, rps=0;
unsigned int temp, flag_t1=0, rpm_real=0, flag_t2=0, segunda=0;
unsigned int flanco=0, flanco_t=0;
float veloc=0;
unsigned int paso_abierto=DESHABILITADO_A;
unsigned int nivel_temp=DESHABILITADO_C;

// Entradas
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
AnalogIn pote(A1);
Dht11 sensor(PTD7);
DigitalIn rev(A2); // Funcion para rpm

//Salidas
PwmOut cooler(A3);

int main(void)
{
    while (true) {
        lectura_tsi();
        modo();
        lazo_cerrado();
        lazo_abierto();
    }
}

void modo()     // Encendido y selector de modo
{
    static unsigned int paso_modo=ESPERO_ARRANQUE;
    switch(paso_modo) {
        case ESPERO_ARRANQUE:
            if(variacion_tsi == 1 &&  alto == 0) {  // alto = flag para detectar el flanco
                alto=1;
                printf("Comienzo\n\r");
                printf("LAZO ABIERTO\n\r");
                paso_modo=MODO_A;
            }
            break;
        case MODO_A:
            hab_modo_a=1;
            hab_modo_c=0;
            if(variacion_tsi == 1  && alto == 0) {
                alto=1;
                printf("LAZO CERRADO\n\r");
                paso_modo=MODO_C;
            }
            break;
        case MODO_C:
            hab_modo_a=0;
            hab_modo_c=1;
            if(variacion_tsi == 1 && alto == 0) {
                alto=1;
                printf("LAZO ABIERTO\n\r");
                paso_modo=MODO_A;
            }
            break;
    }
}

void lazo_cerrado()
{
    switch(nivel_temp) {
        case DESHABILITADO_C:   // Este caso espera que se habilite la maquina de estados
            if(hab_modo_c == 1) {
                hab_sens_temp=1;
                nivel_temp=LEO_TEMP;
            }
            break;
        case LEO_TEMP:  // despues de 2 segundos attachea una funcion que lee la temperatura
            if(flanco_t == 0) { // flag para que entre una sola vez
                flanco_t=1;
                temperatura.attach(&sensado_temp, 2);
            }
            if(hab_modo_c == 0) {   // si se cambia el modo se deshabilita la maquina de estados
                nivel_temp=DESHABILITADO_C;
                hab_sens_temp=0;
            }
            break;
        case CALC_RPM:  // Mido la cantidad de veces que se pone en 1 la pata del cooler de las revoluciones y saco el calculo dentro de un tiempo
            if(flag_t2 == 0) {  // para obtener las revoluciones por minuto
                flag_t2=1;
                velocidad.attach(&calculo_vel_lc, 0.5);
            }
            if(rev == 0 && flanco==1) { // flanco = variable para detectar el flanco
                flanco=0;
            }
            if(rev == 1 && flanco==0) {
                flanco=1;
                rps++;
            }
            if(hab_modo_c == 0) {
                nivel_temp=DESHABILITADO_C;
                hab_sens_temp=0;
            }
            break;
        case COMPARO:   // comparo las RPM que deberia haber teoricamente con las que fueron medidas anteriormente y corrijo
            segunda=1;
            rpm_real=(140*temp)-2600;   // calculo teorico
            if(rpm_real <= 200) {
                printf("RPM TEORICO = 200\n\r");
            } else if(rpm_real > 200) {
                printf("RPM TEORICO = %d\n\r",rpm_real);
            }
            if(temp > 20 && temp < 70) {
                if(rpm_real > rpm) {    // si las rpm teoricas son superiores a las medidas aumentamos las rpm
                    cooler.write(veloc + 0.05);
                } else if(rpm_real < rpm) { // si las rpm teoricas son inferiores a las medidas bajamos las rpm
                    cooler.write(veloc - 0.05);
                }
            }
            nivel_temp=CALC_RPM;    // una vez que comparo y corrigio vuelvo a calcular las rpm
            if(hab_modo_c == 0) {
                nivel_temp=DESHABILITADO_C;
                hab_sens_temp=0;
            }
            break;
    }
}

void lazo_abierto()
{
    switch(paso_abierto) {
        case DESHABILITADO_A:
            if(hab_modo_a == 1) {
                paso_abierto=RECTA;
            }
            break;
        case RECTA:
            if(flag_t1 == 0) {
                if(pote >= 0.027) {  // Asigno el valor del pote al cooler
                    cooler.write(pote);
                } else if(pote < 0.027) {
                    cooler.write(0.027);
                }
                flag_t1=1;
                velocidad.attach(&calculo_vel_la, 0.5);    // Timeout que realiza el calculo de los rpm cada medio segundo
            }
            if(rev == 0 && flanco==1) {
                flanco=0;
            }
            if(rev == 1 && flanco==0) {
                flanco=1;
                rps++;
            }
            if(hab_modo_a == 0) {
                paso_abierto=DESHABILITADO_A;
            }
            break;
    }
}

void sensado_temp() // Funcion que lee el sensor y se guarda en una variable la temperatura
{
    sensor.read();
    temp=sensor.getCelsius();
    printf("T = %d\n\r",temp);
    if(temp <= 20) {
        cooler.write(0.027);
    } else if(temp >= 70) {
        cooler.write(1);
    } else if(temp < 70 && temp > 20) {
        veloc=(0.0195 * temp) - 0.365;  // ecuacion de la velocidad en funcion de la temperatura
        cooler.write(veloc);
    }
    flanco_t=0;
    nivel_temp=CALC_RPM;
}

void calculo_vel_la()   // saco el calculo de las rpm a partir de las revoluciones que midio en un determinado tiempo
{
    rpm=rps*120;
    printf("RPM = %d \n\r", rpm);
    rps=0;
    flag_t1=0;
}

void calculo_vel_lc()   // saco el calculo de las rpm a partir de las revoluciones que midio en un determinado tiempo
{
    rpm=rps*120;
    printf("RPM REAL = %d \n\r", rpm);
    rps=0;
    flag_t1=0;
    if(flag_t2 == 1 && segunda == 0) {
        flag_t2=0;
        nivel_temp=COMPARO;
    } else if(flag_t2 == 1 && segunda == 1) {   // segunda = variable que se pone en 1 luego de haber comparado y corregido
        flag_t2=0;
        segunda=0;
        nivel_temp=LEO_TEMP;
    }
}

void lectura_tsi()  // funcion que lee el tsi
{
    if(tsi.readPercentage() != 0) {
        variacion_tsi=1;
    } else {
        variacion_tsi=0;
        alto=0;
    }
}
