#include "mbed.h"
#include "tsi_sensor.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

#define ESPERO_ARRANQUE 0
#define COMPARO_CABLES 1
#define GANA 2
#define PIERDE 3
#define ESPERO_CABLES 4
#define COMPARACION 5
#define GEN_SEC 6

// Funciones
void CABLES();
void MAQUINA_GENERAL();
void CONTADOR();
void displays();
void t();

//Timer
Ticker timer;

//Salidas
DigitalOut ledr(LED1);
DigitalOut ledg(LED2);
DigitalOut ledb(LED3);
BusOut Unidades (PTE5,PTE4,PTE3,PTE2);
BusOut Decenas (PTB11,PTB10,PTB9,PTB8);

//Entradas
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
DigitalIn C1(A1);
DigitalIn C2(A2);
DigitalIn C3(A3);
DigitalIn C4(A4);

// Variables
volatile unsigned int tiempo=0;
unsigned int n=0, habcables=0, gen=0, perdiste=0, finsec=0, reed_time=0, segundos=20, fin_tiempo=0;
unsigned int variacion=0;
unsigned int uni=0, dec=0;
int vector[4];
int jugador[4];

int main(void)
{
    C1.mode(PullUp);    // Le seteo PullUp a las entradas de los cables para que cuando esten al aire detecte un 1
    C2.mode(PullUp);
    C3.mode(PullUp);
    C4.mode(PullUp);
    ledg=1;
    ledr=1;
    ledb=1;
    timer.attach(&t,0.01);
    while (true) {
        gen++;  // SEMILLA
        CABLES();
        MAQUINA_GENERAL();
        CONTADOR();
        displays();
    }
}


void MAQUINA_GENERAL() // Maquina de estados: funcionamiento general del programa
{
    static unsigned int paso_general=ESPERO_ARRANQUE;
    unsigned int num=0;
    switch(paso_general) {
        case ESPERO_ARRANQUE:   // RESET
            n=0;
            tiempo=0;
            num=0;
            variacion=0;
            perdiste=0;
            if(tsi.readPercentage() != 0) {
                paso_general=GEN_SEC;
                printf("Comienzo\n\r");
            }
            break;
        case GEN_SEC:   // Genero una secuencia aleatoria encargandome de que no se repitan
            for(num=0; num<4; num++) {
                srand(++gen);
                vector[num]=1+rand()%4;
                if(num==1) {
                    while(vector[1]==vector[0]) {
                        srand(++gen);
                        vector[1]=1+rand()%4;
                    }
                } else if(num==2) {
                    while(vector[2]==vector[1]|| vector[2]==vector[0]) {
                        srand(++gen);
                        vector[2]=1+rand()%4;
                    }
                } else if(num==3) {
                    while(vector[3]==vector[2]|| vector[3]==vector[1] || vector[3]==vector[0]) {
                        srand(++gen);
                        vector[3]=1+rand()%4;
                    }
                }
                printf("%d\r\n", vector[num]);
            }
            paso_general=COMPARO_CABLES;
            break;
        case COMPARO_CABLES:    // Habilito la maquina de estados de comparacion de cables con secuencia
            habcables=1;
            if(perdiste == 1 || fin_tiempo==1) { //Si se levanta el flag de perdida paso al caso "PIERDE"
                perdiste=0;
                printf("Perdiste\r\n");
                tiempo=150;
                paso_general=PIERDE;
            }
            if(finsec == 1) {   //Si se levanta el flag de perdida paso al caso "GANA"
                finsec=0;
                printf("Ganaste\r\n");
                tiempo=150;
                paso_general=GANA;
            }
            break;
        case GANA:  // Enciendo el led verde y titilo displays hasta reiniciar el juego
            ledg=0;
            if(tiempo == 100) {
                Unidades=uni;
                Decenas=dec;
            }
            if(tiempo == 50) {
                Unidades=15;
                Decenas=15;
            }
            if(tiempo == 0) {
                tiempo=120;
            }
            if(tsi.readPercentage() != 0 && C1 == 0 && C2 == 0 && C3 == 0 && C4 == 0 ) {
                n=0;
                ledg=1;
                tiempo=0;
                perdiste=0;
                finsec=0;
                fin_tiempo=0;
                segundos=20;
                num=0;
                variacion=0;
                paso_general=GEN_SEC;
                printf("Comienzo\n\r");
            }
            break;
        case PIERDE:    // Titilo el led rojo y los displays hasta reiniciar el juego
            if(tiempo == 100) {
                ledr=0;
                Unidades=uni;
                Decenas=dec;
            }
            if(tiempo == 50) {
                ledr=1;
                Unidades=15;
                Decenas=15;
            }
            if(tiempo == 0) {
                tiempo=120;
            }
            if(tsi.readPercentage() != 0 && C1 == 0 && C2 == 0 && C3 == 0 && C4 == 0 ) {
                n=0;
                ledg=1;
                ledr=1;
                tiempo=0;
                perdiste=0;
                finsec=0;
                fin_tiempo=0;
                segundos=20;
                num=0;
                variacion=0;
                paso_general=GEN_SEC;
                printf("Comienzo\n\r");
            }
            break;
    }
}


void CABLES()   // Maquina de estados: comparo la secuencia generada con el cable desconectado
{
    static unsigned int paso_cables=ESPERO_CABLES;
    static unsigned int fail=0, bloqueo_cable1=0, bloqueo_cable2=0, bloqueo_cable3=0, bloqueo_cable4=0;
    switch(paso_cables) {
        case ESPERO_CABLES:
            if(habcables == 1) {
                paso_cables=COMPARACION;
            }
            break;
        case COMPARACION:   // Si se desconecta un cable se levanta un flag de variacion y se bloquea ese cable para que no se vuelva a detectar
            if(C1 == 1 && bloqueo_cable1 == 0) {    
                bloqueo_cable1=1;
                variacion=1;
                jugador[n]=1;
            } else if(C2 == 1 && bloqueo_cable2 == 0) {
                bloqueo_cable2=1;
                variacion=1;
                jugador[n]=2;
            } else if(C3 == 1 && bloqueo_cable3 == 0) {
                bloqueo_cable3=1;
                variacion=1;
                jugador[n]=3;
            } else if(C4 == 1 && bloqueo_cable4 == 0) {
                bloqueo_cable4=1;
                variacion=1;
                jugador[n]=4;
            }
            if(variacion == 1) { // Si se levanta el flag de variacion comparo el cable con la secuencia
                if(jugador[n] == vector[n]) {
                    printf("Bien hecho!\n\r");  // Si coincide pasa de nivel
                    n++;
                } else fail=1;  // Si difiere levanto el flag de partida perdida
                variacion=0;
            }
            if(fail == 1) { //reinicio las variables y levanto el flag de perdida
                perdiste=1;
                habcables=0;
                bloqueo_cable1=0;
                bloqueo_cable2=0;
                bloqueo_cable3=0;
                bloqueo_cable4=0;
                fail=0;
                paso_cables=ESPERO_CABLES;
            } else if(n == 4) { // Si llego al nivel 4 quiere decir que termino el juego y ganaste. Levanto el flag de victoria
                finsec=1;
                bloqueo_cable1=0;
                bloqueo_cable2=0;
                bloqueo_cable3=0;
                bloqueo_cable4=0;
                variacion=0;
                habcables=0;
                paso_cables=ESPERO_CABLES;
            }
            break;
    }
}

void CONTADOR()     // Decremento una variable cada 1 segundo que corresponde al tiempo de juego. La variable comienza en 30
{
    static unsigned int comienzo=0;
    if(habcables == 1) {
        if(comienzo == 0) {
            tiempo=0;
            comienzo=1;
        }
        if(tiempo == 0 && fin_tiempo == 0) {
            segundos--;
            reed_time=0;
            tiempo=100;
        }
        if(segundos == -1 && fin_tiempo == 0) {
            fin_tiempo=1;
            segundos++;
            printf("Se acabo el tiempo!\n\r");
        }
    }
}

void displays() // Envio de informacion de tiempo de juego a displays
{
    dec=segundos/10;
    uni=segundos%10;
    if(reed_time == 0 && fin_tiempo == 0) {
        Unidades=uni;
        Decenas=dec;
        reed_time=1;
    }
}



void t()
{
    if (tiempo > 0)
        tiempo--;
}