

#include "mbed.h"                       // stock MBED API
#include "C12832.h"                     // for the LCD 
#include "LM75B.h"                      // for the temperature sensor

// various globals 


Serial host (USBTX, USBRX);             // to-host UART via OpenSDAv2 

C12832 shld_lcd (D11, D13, D12, D7, D10);   // LCD on the shield (128x32)

LM75B lm_temp (D14, D15);               // temperature sensor 


InterruptIn sw2_int (PTC6);             // interrupts for the two on-board switches 
InterruptIn sw3_int (PTA4);

static volatile int sw2_trig;           // switches triggered?
static volatile int sw3_trig;


//various interrupt handlers

void sw2_interrupt (void)       // trig 2 interrupt handler
{
    sw2_trig = 1;
}


void sw3_interrupt (void)     //trig 3 interrupt handler 
{
    sw3_trig = 1;
}

/*
 *The main method displays the temperature in F and C, the different temperature metrics can be accessed by using the two
 triggers on the device SW2 and SW3. 
 */
int main (void)
{
    
    host.baud (38400);
    
    // Initialsising variable for the triggers   
    sw2_trig = 0;
    sw3_trig = 0;
    
    // Initialising a variable for the different modes (F or C)
    int mode = 0;

    sw2_int.mode (PullUp);
    sw2_int.fall (&sw2_interrupt);
    
    sw3_int.mode (PullUp);
    sw3_int.fall (&sw3_interrupt);
    
    shld_lcd.cls ();
    shld_lcd.locate (1, 1);
    
    //Prints this to the lcd
    shld_lcd.printf ("The current temperature is:");
   
    
 
    // this loop will run forever
    for (;;) {
        wait (0.7);                            // approx 50 cycles/sec
        
         // every 32 cycles, or thereabouts (will be truncated) 
        float t = lm_temp.read ();
         
        //switch the temp to C
        if (sw2_trig) {
            mode = 0;
            sw2_trig = 0;   
            }
            
        //switch the temp to F   
        if (sw3_trig) {
            mode = 1;
            sw3_trig = 0; 
            }
                        
        // display the temp to the serial HOST and LCD if the temp is in C    
        if(mode == 0){
            
            host.printf ("Temperature: %.2f celsuis \r\n", t);
            shld_lcd.locate (1, 10);
            shld_lcd.printf ("%.2f C", t);
        
        }
        // display the temp to the serial HOST and LCD if the temp is in F  
        else if (mode == 1){
            
            float tf = (t * 9.0/5.0  + 32);
            host.printf ("Temperature: %.2f fehrenheit \r\n", tf);
            shld_lcd.locate (1, 10);
            shld_lcd.printf ("%.2f F", tf);
        
            
        }    
            
    }
}
