
#define USE_LCD 1

#if USE_LCD
#include "C12832.h"

#if defined(TARGET_UBLOX_C027)
#warning "Compiling for mbed C027"
#include "C027.h"
#elif defined(TARGET_LPC1768)
#warning "Compiling for mbed LPC1768"
#include "LPC1768.h"
#elif defined(TARGET_K64F)
#warning "Compiling for mbed K64F"
#include "K64F.h"
#endif

#define printf lcd.cls();lcd.printf

#endif

#define MQTTCLIENT_QOS2 1

#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "USBSerial.h"
#include "C12832.h"
#include "MMA7660.h"

MMA7660 MMA(D14, D15);

int arrivedcount = 0;


void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}


int main(int argc, char* argv[],float c,float ang)
{   
    lcd.cls();
    lcd.locate(0,3);
    printf("mbed application shield!");
    


    while(1) {
        wait(0.1f);
        lcd.locate(0,14);
        float c=MMA.y()/MMA.z();
         float ang=pow(c,(-1));
            printf("%.2f,%.2f,%.2f",MMA.x(),MMA.y(),MMA.z());
            printf("%.2f",ang);
      
    }
    if (ang<=-1){
    MQTTEthernet ipstack = MQTTEthernet();
    float version = 0.5;
    char* topic = "door";
    
    printf("HelloMQTT: version is %f\n", version);
              
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    char* hostname = "doughnut.kent.ac.uk";
    int port = 1883;
    printf("Connecting to %s:%d\n", hostname, port);
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\n", rc);
 
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-sample";
    data.username.cstring = "testuser";
    data.password.cstring = "testpassword";
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\n", rc);
    
    if ((rc = client.subscribe(topic, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\n", rc);

    MQTT::Message message;

    // QoS 0
    char buf[100];
    sprintf(buf, "door opened %f\n", version);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    while (arrivedcount < 1)
        client.yield(100);
        
   
            
    if ((rc = client.unsubscribe(topic)) != 0)
        printf("rc from unsubscribe was %d\n", rc);
    
    if ((rc = client.disconnect()) != 0)
        printf("rc from disconnect was %d\n", rc);
    
    ipstack.disconnect();
    
    printf("Version %.2f: finish %d msgs\n", version, arrivedcount);
    
    return 0;
}
}
