/*
 *  Marc Le Labourier
 *  16/02/2016
 */
 
#ifndef LCD_H
#define LCD_H

#define SCREEN_SIZE 2
#define SCREEN_CHAR 25
#define SCREEN_PADDING 10

#include <string>
#include <list>
#include "mbed.h"
#include "C12832.h"

/* LCD MODULE
 * LCD library in order to transform the mbed application shield lcd into
 * a visual terminal with a good display of every line.
 */
class LCD
{
public:
    LCD();
    virtual             ~LCD();
    C12832&             Host();
    void                clear();
    void                print(const std::string&);
private:
    void                                printOne(const std::string&, int);
    void                                printAll();
    int                                 _line;
    int                                 _pos;
    std::list<std::string>::iterator    _it;
    std::list<std::string>              _buffer;
    C12832                              _host;
};

#endif