/*
 *  Marc Le Labourier
 *  16/02/2016
 */
 
 #include "LCD.h"
 
LCD::LCD() : _host(D11, D13, D12, D7, D10)
{
    _line = 0;
    _pos = 0;
    _it = _buffer.begin();
}

LCD::~LCD()
{
    _buffer.clear();
}

C12832&     LCD::Host()
{
    return _host;
}

/* Clear process:
 * The screen buffer is full...
 * We need to extract one line and to redisplay the content from the start of the buffer.
 * If we do not wait during the process, the screen will not be readable.
 * The wait_ms is responsible of the 'scrolling effect'.
 */
void                LCD::clear()
{
    wait_ms(1000);
    if (_buffer.size() > SCREEN_SIZE)
        _buffer.pop_front();
    _host.cls();
}

/* Push a string to be rendered on the LCD screen:
 * Long string are split in many other and added to the buffer.
 */
void                LCD::print(const std::string& s)
{
    if (s.size() > SCREEN_CHAR)
    {
        for (size_t i = 0; i < s.size(); i += SCREEN_CHAR)
        {
            std::string tmp = s.substr(i, SCREEN_CHAR);
            _buffer.push_back(tmp);
        }
    }
    else
        _buffer.push_back(s);
    printAll();
}

/* Update the screen process
 * Update the screen with the new input from the print() method.
 * All the magic is done here.
 */
void                LCD::printAll()
{
    if (_it == _buffer.end())
    {
        _it = _buffer.begin();
        for (int i = 0; i < _line; ++i)
            ++_it;
    }
    for (; _it != _buffer.end(); ++_it)
    {
        if (_line > SCREEN_SIZE)
        {
            _line = 0;
            _pos = 0;
            clear();
            _it = _buffer.begin();
        }
        std::string s = *_it;
        printOne(s, _pos);
        _pos += SCREEN_PADDING;
        ++_line;
    }
}

/* Render a string on the screen */
void                LCD::printOne(const std::string& s, int index)
{
    _host.locate(0, index);
    _host.printf("%s", s.c_str());
}