//
// Created by Marc Le Labourier
// 14-Feb-16.
//

#ifndef MATHALGO_H
#define MATHALGO_H

#include <cmath>
#include <sstream>
#define VAR_PI          3.141592653589793238462643383279502884L /* pi */
#define DIFF(x, y) (x - y)
#define ABS(x) (x < 0 ? x * -1.0f : x)

/* Library of many useful peace of code */

enum Mode {
            Digital,
            Degree,
            Radian
            };

namespace mathalgo
{
    
    inline std::string modeToString(Mode m)
    {
        switch (m) {
            case Digital: return "DIGITAL";
            case Degree: return "DEGREE";
            case Radian: return "RADIAN";
        }
        return "DIGITAL";
    }

    inline Mode modeFromString(const std::string& s)
    {
        if (s.compare("DEGREE") == 0)
            return Degree;
        else if (s.compare("RADIAN") == 0)
            return Radian;
        return Digital;
    }
    
    // How to round a double to a given precision.
    // From: http://stackoverflow.com/questions/11208971/round-a-float-to-a-given-precision
    inline double  pround(double x, int precision)
    {
        if (x == 0.)
            return x;
        int ex = (int)std::floor(std::log10(std::abs(x))) - precision + 1;
        double div = std::pow(10., ex);
        return std::floor(x / div + 0.5) * div;
    }

    inline double  limit(double val, double upper, double lower)
    {
        return (val > upper ? upper : (val < lower ? lower : val));
    }
    
    // Conversion of digital value from [0, 1] to degree or rad.
    inline double   digitalToDegree(double val)
    {
        return val * 360.0;
    }
    
    inline double   degreeToDigital(double val)
    {
        return val / 360.0;
    }
    
    inline double   digitalToRadian(double val)
    {
        return (digitalToDegree(val) * (VAR_PI / 180.0));
    }
    
    inline double   radianToDigital(double val)
    {
        return degreeToDigital(val / (VAR_PI / 180.0));
    }
    
    // Convert float to string without c++11
    inline std::string stof (float number){
        std::ostringstream buff;
        buff << number;
        return buff.str();   
    }
    
    // Convert int to string without c++11
    inline std::string stoi (int number){
        std::ostringstream buff;
        buff << number;
        return buff.str();   
    }
}

#endif // MATHALGO_H