#include "LCD.h"
#include "MathAlgo.hpp"

#define MQTTCLIENT_QOS2 1

#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "picojson.h"

LCD     lcd;
PwmOut  spkr(D6);

#define LED2_OFF 1
#define LED2_ON 0

Serial pc(USBTX, USBRX);

#define printf pc.printf

int arrivedcount = 0;

enum string_code
{
    ALERT,
    LAST,
    NOTKNOWN
};

string_code hashit (std::string const& inString)
{
    if (inString == "/alert") return ALERT;
    if (inString == "/last") return LAST;
    return NOTKNOWN;
}

void alert(const std::string& msg)
{
    picojson::value v;
    const char * json = msg.c_str();
    picojson::parse(v, json, json + msg.size());
    picojson::array list = v.get("coordinates").get<picojson::array>();
    picojson::array::iterator iter = list.begin();
    double lng = (*iter).get<double>();
    ++iter;
    double lat = (*iter).get<double>();
    printf("ALERT : lng = %f / latt = %f\r\n", lng, lat);
    lcd.print("Alert from [lng:" + mathalgo::stof(lng) + "/lat:" + mathalgo::stof(lat) + "]\n");
    for (float i = 2000.0; i < 10000.0; i += 100) {
        spkr.period(1.0/i);
        spkr=0.5;
        wait(0.02);
    }
    spkr=0.0;
}

void last(const std::string& msg)
{
    picojson::value v;
    const char * json = msg.c_str();
    picojson::parse(v, json, json + msg.size());
    picojson::array list = v.get("coordinates").get<picojson::array>();
    picojson::array::iterator iter = list.begin();
    double lng = (*iter).get<double>();
    ++iter;
    double lat = (*iter).get<double>();
    ++iter;
    double depth = (*iter).get<double>();
    double mag = v.get("mag").get<double>();
    std::string title = v.get("title").get<std::string>();
    lcd.print("Event[lng:" + mathalgo::stof(lng) + "/lat:" + mathalgo::stof(lat) + "]\n");
    lcd.print("Title: " + title + "\n");
    lcd.print("Magni: " + mathalgo::stof(mag) + "| Depth:" + mathalgo::stof(depth) + "\n");
}

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;    
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    std::string payload ((char*)message.payload, 0, message.payloadlen);
    std::string topic (md.topicName.lenstring.data, 0, md.topicName.lenstring.len);
    ++arrivedcount;
    
    switch (hashit(topic))
    {
        case ALERT: alert(payload); break;
        case LAST: last(payload); break;
        case NOTKNOWN: printf("Command unknown [%s]\r\n", topic.c_str()); break;
    }
}

int main(int argc, char* argv[])
{   
    char* hostname = "92.222.87.208";
    int port = 1883;
    char* topic1 = "/alert";
    char* topic2 = "/last";

    pc.baud(38400);
    MQTTEthernet ipstack = MQTTEthernet();
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    printf("Connecting to %s:%d\r\n", hostname, port);
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\r\n", rc);
        
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-k64f";
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);
    
    if ((rc = client.subscribe(topic1, MQTT::QOS1, messageArrived)) != 0)
        printf("rc from MQTT subscribe /alert is %d\r\n", rc);
    if ((rc = client.subscribe(topic2, MQTT::QOS1, messageArrived)) != 0)
        printf("rc from MQTT subscribe /last is %d\r\n", rc);

    printf("GO RECEIVE\r\n");
    while (1) {
         client.yield(100);
    }
    return 0;
}
