#include "mbed.h"
#include "FXOS8700Q.h"

// Serial link to the pc
Serial          pc(USBTX, USBRX);
// Accelerometer
FXOS8700Q_acc   accel(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
// Joystick
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn fire(D4);

void pc_interrupt(void)
{
    pc.getc();
    int16_t accX, accY, accZ;
    accel.getX(&accX);
    accel.getY(&accY);
    accel.getZ(&accZ);
    pc.printf("%d;%d;%d;%d;%d;%d;%d;%d;\r\n", accX, accY, accZ, right ? 1 : 0, down ? 1 : 0, left ? 1 : 0, up ? 1 : 0, fire ? 1 : 0);
}

int main(void)
{
    pc.baud(38400);
    pc.attach(&pc_interrupt);
    
    accel.enable();
    wait(.01);
    while (true) {
        sleep();
    }
    accel.disable();   
}