#include "Player.h"

Player::Player()
{
    this->x = DISPLAY_X / 2;
    this->y = DISPLAY_Y / 2;
    this->alive = true;
}

bool    Player::move(const int &x, const int &y)
{
    bool okMove = true;
    float newX = this->x + static_cast<float>(x) / DELTA_MOVE;
    float newY = this->y + static_cast<float>(y) / DELTA_MOVE;

    // TODO, opti this but clearer at the moment
    if (newX < 0 || newY < 0) {
        newX = (newX < 0 ? 0 : newX);
        newY = (newY < 0 ? 0 : newY);
        okMove = false;
    }

    if (newX > DISPLAY_X - 1 || newY > DISPLAY_Y - 1) {
        newX = (newX > DISPLAY_X - 1 ? DISPLAY_X - 1 : newX);
        newY = (newY > DISPLAY_Y - 1 ? DISPLAY_Y - 1 : newY);
        okMove = false;
    }

    this->x = newX;
    this->y = newY;
    return okMove;
}

bool    Player::die()
{
    this->alive = false;
}

bool    Player::isAlive() const
{
    return this->alive;
}

int     Player::getX() const
{
    return static_cast<int>(this->x);
}

int     Player::getY() const
{
    return static_cast<int>(this->y);
}