#include "Asteroid.h"

Asteroid::Asteroid()
{
    this->a = static_cast<float>(rand()) / (static_cast<float>(RAND_MAX)) - 0.5f;
    this->b = rand() % DISPLAY_Y;
    if (rand() % 2 == 1) {
        this->x = 0;
        this->inc = 1;
    } else {
        this->x = DISPLAY_X;
        this->inc = -1;
    }
#if defined _DEBUG
    host.printf("New Asteroid !\r\n");
#endif
}

Asteroid::~Asteroid()
{
#if defined _DEBUG
    host.printf("Deleting Asteroid !\r\n");
#endif
}

bool    Asteroid::move(Player *player)
{
    this->x += this->inc;
    if ((this->getX() == player->getX() || this->getX() == player->getX() + 1) &&
            (this->getY() == player->getY() || this->getY() == player->getY() + 1)) {
        player->die();
    }
    if (this->inc == 1 && this->x == DISPLAY_X + 1) {
        return false;
    } else if (this->inc == -1 && this->x == -1) {
        return false;
    } else {
        return true;
    }
}

int     Asteroid::getX() const
{
    return x;
}

int     Asteroid::getY() const
{
    return static_cast<int>(this->a * this->x + this->b);
}
