#ifndef _GAME_H_
# define _GAME_H_

# include "main.h"
# include "Player.h"
# include "Asteroid.h"

# include <list>
# include <iterator>

class Game
{
public:
    Game();
    ~Game();
    static void             threader(void const *p);
    void                    loop();
    void                    watchAccel();
    void                    display();
    void                    process();
    void                    move();
    void                    factory();
    void                    generate();
private:
    Player                  *player;
    Thread                  thread;
    Mutex                   mutex;
    C12832                  *lcd;
    FXOS8700Q_acc           *accel;
    DigitalIn               boost;
    int16_t                 steadyPosition;
    unsigned int            score;
    unsigned short int      delta;
    unsigned short int      next;
    std::list<Asteroid*>    asteroids;
};

#endif /* _GAME_H_ */