/**
* This project is using the following inputs:
*  - SW2 Button (right): Used to navigate between the different states (views)
*  - SW3 Button (left): Used to change the state mode -if the state has another mode-
*  - POT1 Potentiometer (left): Used to change the update rate (in seconds)
*
* The project is constructed around one class: Core.
* This class will manage the inputs, and the different states
* (I am using a state machine, based on the state ID, and the function pointer of this state).
* The states functions are called state*StateName*.
*
* The current states are:
*  - Temperature state
*    => This state has 2 modes (SW3 Button to switch): Celsius or Fahrenheit temperature
*  - Accelerometer state
*  - Magnetometer state
*
* All the outputs are done on the shield LCD.
*
* The documentation for each methods is defined in the core.h file
*/
#include "core.h"

int main ()
{
    Core core;
    core.init();
    while (true)
    {
        core.update();
    }
}
