#ifndef CORE_H_
#define CORE_H_

#include <stdarg.h>
#include "mbed.h"
#include "LM75B.h" // temperature
#include "C12832.h" // lcd
#include "FXOS8700Q.h" // accelerometer

#define MODES_COUNT 3
#define SCREEN_REFRESH_VALUE 1

class Core {
    public:
        Core() :
                m_mode(Temperature),
                m_ledR(D5),
                m_ledG(D8),
                m_ledB(D9),
                m_lcd(D11, D13, D12, D7, D10),
                m_temperature(D14, D15),
                m_btnNext(PTC6),
                m_btnOpt(PTA4),
                m_optTrigger(false),
                m_i2c(PTE25, PTE24),
                m_accelerometer(m_i2c, FXOS8700CQ_SLAVE_ADDR1),
                m_magnetometer(m_i2c, FXOS8700CQ_SLAVE_ADDR1),
                m_stateEntred(false),
                m_updateRate(SCREEN_REFRESH_VALUE),
                m_potentiometerLeft(A0)
                {}
        virtual ~Core() {}
        enum Mode {
            Temperature = 0,
            Accelerometer,
            Magnetometer
        };
    
    public:
        /**
        * Switch to next mode
        */
        void nextMode();
        /**
        * Init devices
        */
        void init();
        /**
        * Update datas (called on each "frame")
        */
        void update();
        
    private:
        /**
        * Used to change the shield led color
        */
        void setLedColor(float red, float green, float blue);
        /**
        * Used to write text on the LCD screen
        */
        void writeText(const char* text, int x, int y, ...);
        
    // Triggers
    private:
        void optTrigger();
        void nextTrigger();
        void updateStateTrigger();
        
    // States
    private:
        void stateTemperature();
        void stateAccelerometer();
        void stateMagnetometer();
    
    private:
        volatile Mode m_mode; /*< The current selected state */
        PwmOut m_ledR; /*< the LED Red color controller */
        PwmOut m_ledG; /*< the LED Green color controller */
        PwmOut m_ledB; /*< the LED Blue color controller */
        C12832 m_lcd; /*< The LCD Object */
        LM75B m_temperature; /*< The temperature mesurement device */
        InterruptIn m_btnNext; /*< The SW2 button */
        InterruptIn m_btnOpt; /*< The SW3 button */
        void (Core::*m_states[MODES_COUNT])(); /*< Method pointers array for the states */
        volatile bool m_optTrigger; /*< Manage the states modes */
        Ticker m_stateTicker; /*< The state ticker, to update the scene */
        I2C m_i2c; /*< i2c definition */
        FXOS8700QAccelerometer m_accelerometer; /*< the accelerometer device */
        FXOS8700QMagnetometer m_magnetometer; /*< the magnetometer device */
        bool m_stateEntred; /*< Defined to false when entring to a new state. Used to enable the used device */
        float m_updateRate; /*< The update rate (in seconds */
        AnalogIn m_potentiometerLeft; /*< the potentiometer device */
};

#endif /* !CORE_H_ */