#include "core.h"
#define M_PI 3.14159265358979323846

// Tickers

void Core::optTrigger()
{
    m_optTrigger = !m_optTrigger;
}

void Core::nextTrigger()
{
    nextMode();
}

void Core::updateStateTrigger() {/* Used only to interrupt sleep */}

// End tickers

void Core::nextMode()
{
    m_mode = static_cast<Mode>(((int)m_mode + 1) % MODES_COUNT);
    m_accelerometer.disable();
    m_magnetometer.disable();
    m_stateEntred = false;
}

void Core::init()
{
    writeText("Init...", 0, 3);
    // Init states
    m_states[Temperature] = &Core::stateTemperature;
    m_states[Accelerometer] = &Core::stateAccelerometer;
    m_states[Magnetometer] = &Core::stateMagnetometer;
    
    // Init buttons
    m_btnOpt.mode(PullUp);
    m_btnOpt.fall(this, &Core::optTrigger);
    
    m_btnNext.mode(PullUp);
    m_btnNext.fall(this, &Core::nextTrigger);
    
    m_stateTicker.attach(this, &Core::updateStateTrigger, m_updateRate);
}

void Core::update()
{
    m_lcd.cls();
    (this->*m_states[m_mode])();
    float rateValue = (float)m_potentiometerLeft * 10;
    writeText("Update rate: %1.1fs", 0, 21, rateValue);
    // update rate if modified
    if (m_updateRate != rateValue)
    {
        m_updateRate = rateValue;
        m_stateTicker.detach();
        m_stateTicker.attach(this, &Core::updateStateTrigger, m_updateRate);
    }
    sleep();
}

void Core::setLedColor(float red, float green, float blue)
{
    m_ledR = red;
    m_ledG = green;
    m_ledB = blue;
}

void Core::writeText(const char* format, int x, int y, ...)
{
    char buffer[strlen(format) + 32];
    
    // Using va_list to set arguments like a printf
    va_list args;
    va_start(args, y);
    vsprintf(buffer, format, args);
    va_end(args);
    
    // Setting location and writing on screen
    m_lcd.locate(x, y);
    m_lcd.printf(buffer);
}

// STATES

void Core::stateTemperature()
{
    char type;
    float temp;
    
    if (m_optTrigger) {
        type = 'F';
        temp = m_temperature.temp() * 9 / 5 + 32;
    } else {
        type = 'C';
        temp = m_temperature.temp();
    }
    writeText("Temperature\n", 35, 3);
    writeText("%1.f %c\n", 56, 12, temp, type);
}

void Core::stateAccelerometer()
{
    motion_data_units_t data;
    
    if (!m_stateEntred)
    {
        m_stateEntred = true;
        m_accelerometer.enable();
    }
    m_accelerometer.getAxis(data);
    writeText("Accelerometer\n", 33, 3);
    writeText("X=%4.1f Y=%4.1f Z=%4.1f\n", 0, 12, data.x, data.y, data.z);
}

void Core::stateMagnetometer()
{
    motion_data_units_t data;
    
    if (!m_stateEntred)
    {
        m_stateEntred = true;
        m_magnetometer.enable();
    }
    m_magnetometer.getAxis(data);
    writeText("Magnetometer\n", 33, 3);
    writeText("X=%4.1f Y=%4.1f Z=%4.1f\n", 0, 12, data.x, data.y, data.z);
}