/*
* Author - Aruna Duraisingam - ad543 
* Date - 20 Feb 2016
* The below program is developed beased on IOT assessment 3 requirements.
* The below program reads temperature for ever 5 sesonds 
* and when the temperature goes higher than 26 degree celcius the progam shuts down the 
* processor for 5 seconds and comes back again. The processor can also be make active when a
* switch is pressed.
*/

#include "mbed.h"                       /* stock MBED API */
#include "LM75B.h"                      /* Lib for the temperature sensor */
#include "C12832.h"                      /* Lib for LCD Display */
#include "FXOS8700Q.h"                      /* Lib for on-board Accelerometer/Magnetometer */
#include "eCompass_Lib.h"
#include "rtos.h"
#include "math.h"                      

/**************** Declaration *********************/

Serial host (USBTX, USBRX);             /* to-host UART via OpenSDAv2 */


LM75B sens_temp (D14, D15);               /* temperature sensor */
PwmOut speaker(D6); /* speaker */

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
C12832 lcd_display (D11, D13, D12, D7, D10);   /* LCD on the shield (128x32) */
Ticker blinker;
AnalogIn pot1 (A0); // Potentiometer

eCompass compass;


// JoyStick
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);

//Accelerometer/magnetometer

I2C i2c(PTE25, PTE24);
//FXOS8700Q fxos(i2c, FXOS8700CQ_SLAVE_ADDR1);
FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);    // Configured for the FRDM-K64F with onboard sensors
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);

extern axis6_t axis6;

MotionSensorDataCounts mag_raw;
MotionSensorDataCounts acc_raw;

InterruptIn wakeup_switch (PTC6);             /* interrupts for the two on-board switches */
InterruptIn temp_conversion_switch (PTA4);

/* option trigger/flag (integer value) . possible values 1,2,3 - what to display in LCD 
option 1 - read temperature and display in LCD in celcius/fareinheit
option 2 - Simple ball game using accelerometer reading
option 3 - Magentometer showing direction.
*/
static volatile int joystick_option_flag;   
        

static volatile int temp_conversion_switch_trig;        /* 0- gives reading in celcius and 1 in farenheit.*/

static volatile float threshold_temperature = 29.0; /* given in degree celcius*/
static volatile bool isActive = true;
static volatile bool activate_blink = false;

// login
static char username[10] ;
static char password[10] ;
static char * tempstring ;
static bool validateUser = false;

/*****************************Methods***************************/

void hal_map( MotionSensorDataCounts * acc_raw, MotionSensorDataCounts * mag_raw)
{
int16_t t;
// swap and negate X & Y axis
t = acc_raw->x;
acc_raw->x = acc_raw->y * -1;
acc_raw->y = t * -1;
// swap mag X & Y axis
t = mag_raw->x;
mag_raw->x = mag_raw->y;
mag_raw->y = t;
// negate mag Z axis
mag_raw->z *= -1;
}

//Toggles the temperature conversion switch  trigger
void conversion_switch_interrupt (void)
{
    temp_conversion_switch_trig = !temp_conversion_switch_trig;
}

// reactivate the processor and starts execution
void wakeup_switch_interrupt (void)
{
    led_green=1;    
    activate_blink = false;
    isActive = true;
    lcd_display.cls();
}

// When the temperature is above threshold limit,  it sets an alaram for 3 seconds and sleep
void setAlarm (void)
{
    led_red = 0;
    speaker.period(1.0/500.0); // 500hz period
    speaker =0.5; //50% duty cycle - max volume
    wait(1.5f);
    speaker=0.0; // turn off audio
    led_red = !led_red; // toggle a led    
}

void makeProcessorSleep(void){
    isActive = false;
    activate_blink = true;
    sleep();
}

void blink() {
    if(activate_blink)
        led_green=!led_green;
}

void initialize() {
       
    temp_conversion_switch_trig =1; 
    joystick_option_flag = 1; // intially 
    led_red = 1;
    led_green = 1;
}

void displayTemperature(float temp)
{
    if (temp_conversion_switch_trig) {
                    lcd_display.printf ("Temperature %.2f C", temp);                        
                    }
                else{
                    float f = (temp*9/5)+32;
                    lcd_display.printf ("Temperature %.2f F", f);                 
                    } 
}

void displayGame(void)
{
    
}

void displayDirection(void)
{
    lcd_display.cls();
    acc.getAxis( acc_raw);
        mag.getAxis( mag_raw);
        compass.run( acc_raw, mag_raw); // calculate the eCompass
         int yaw =axis6.yaw;
         
        if((yaw >=338 && yaw <360) || (yaw>=0 && yaw < 23)) lcd_display.printf("%d degree North\r\n", yaw);
        else if((yaw >=24 && yaw <67)) lcd_display.printf("%d degree Nort East", yaw); 
        else if((yaw >=68 && yaw <112)) lcd_display.printf("%d degree East", yaw); 
        else if(yaw >=113 && yaw <158) lcd_display.printf("%d degree South East", yaw); 
        else if(yaw >=159 && yaw <203) lcd_display.printf("%d degree South", yaw); 
        else if(yaw >=204 && yaw <247) lcd_display.printf("%d degree South West", yaw); 
        else if(yaw >=248 && yaw <292) lcd_display.printf("%d degree West", yaw); 
        else lcd_display.printf("%d degree North West\r\n", yaw);        
}


char* readString(void){
     tempstring = (char*) malloc(10 * sizeof(char));
     int i =0;
     bool status = true;
     while(status) {
        char ch = host.getc();
       if(ch != '\r')
       {
            lcd_display.printf("%c", ch);
            tempstring[i]= ch;
            i++;
        }
        else
        {        
            //lcd_display.printf("Entered enter!");
            printf("\n");
            status =false;
        }
        
        
    }
    
    tempstring[i] = '\0';
    return tempstring;
 }
 
 void getUserNameText(void){
     host.printf("Please enter username (Max 10 characters): \r\n");
     strcpy(username , readString());
}
 
 void login(void){
     
      host.printf("Please enter username (Max 10 characters): \r\n");
      strcpy(username , readString());  
      
      
      host.printf("Please enter password (Max 10 Characters):\r\n");
      strcpy(password , readString());      
       
       host.printf("Username :%s , Password : %s \r\n", username, password);      
     }

/************** Start - Main Method **************************/
int main (void)
    {
        host.baud (38400); 
        login();
       
       if(strcmp (username,"default") == 0  && strcmp (password,"default") == 0)
       {
            validateUser = true;
            free(username);
            free(password);  
        }
        else{
            host.printf("Invalid login\r\n"); 
            login();
           }
        
        initialize();
        
        wakeup_switch.mode (PullUp);
        wakeup_switch.fall (&wakeup_switch_interrupt);
        
        temp_conversion_switch.mode (PullUp);
        temp_conversion_switch.fall (&conversion_switch_interrupt); 
        
        up.mode(PullUp);  
        left.mode(PullUp); 
        right.mode(PullUp); 
        down.mode(PullUp);      
        
        blinker.attach(&blink, 1); 
        
        acc.enable();
        mag.enable();

        acc.getAxis( acc_raw);
        mag.getAxis( mag_raw);
             
        while(isActive){
           host.printf ("validateUser %d", validateUser);
           if(!validateUser) sleep();
           else{               
                   lcd_display.locate (1, 10);
                   lcd_display.cls();
                   
                    float curr_temp = sens_temp.read ();
                    
                    if(up)  joystick_option_flag = 1;
                    else if(left)joystick_option_flag = 2;
                    else if(right)joystick_option_flag = 3;            
                    
                    host.printf ("option joystick: %d \r\n", joystick_option_flag);
                    
                    switch (joystick_option_flag) {
                    case 1:      
                        displayTemperature(curr_temp);               
                        break;
                    case 2:
                        displayGame();
                        break;
                    case 3:
                        displayDirection(); 
                        break; 
                    default:
                        displayTemperature(curr_temp);               
                    }            
                   
                    if(curr_temp > threshold_temperature)
                    {
                       setAlarm();  
                       lcd_display.printf ("In Sleep Mode. Temperature: %.2f C\r\n", curr_temp);         
                       makeProcessorSleep();                   
                    }      
                    
                    wait (1.0f);  
                }
        }
    }