/* Include mbed library */
#include "mbed.h"

/* Include LCD library */
#include "C12832.h"

/* include MQTT library */
#include "MQTTEthernet.h"
#include "MQTTClient.h"

/* Include Json Library */
#include "picojson.h"


/* Communication with the host (serial over USB) */
Serial host (USBTX, USBRX);   

/* LED on main card */
DigitalOut gpo(D0);
DigitalOut ledR(LED_RED);
DigitalOut ledG(LED_GREEN);


/* LED on shield card */
PwmOut red(D5);
PwmOut green(D9);

/* LCD on the shield (128x32) */
C12832 shlcd (D11, D13, D12, D7, D10);

/* Joystics */
DigitalIn select(D4);

/* Speaker */
PwmOut speaker(D6);

static volatile int Check = 0;
static int err = 0;

/* Put all led off */
void ledOff()
{
    ledR = 1;
    ledG = 1;  
    red.write(1.0f);
    green.write(1.0f);
}

/* Show hostname and port on lcd */
void showHostPort(char *host, int port)
{
    shlcd.cls();
    shlcd.locate(40,2);
    shlcd.printf("Welcome");
    shlcd.locate(5,10);
    shlcd.printf("Connecting to : ");
    shlcd.locate(5,18);
    shlcd.printf("%s:%d", host, port);
    wait(0.2f);
}

/* Show error msg on lcd */
void showErrorMsg(int rc)
{
    shlcd.cls();
    shlcd.locate(5,2);
    shlcd.printf("An error occured,");
    shlcd.locate(5,10);
    shlcd.printf("pls restart the application");
    shlcd.locate(5,18);
    if (rc == 1)
        shlcd.printf("Connection fail to the host");
    else if (rc == 2)
        shlcd.printf("Client: Invalid information");
    else
        shlcd.printf("Fail to subscribe");
    wait(4.0f);
}

/* Show subscribe msg on lcd */
void showSubscribe(char *topic)
{
    shlcd.cls();
    shlcd.locate(40,2);
    shlcd.printf("Welcome");
    shlcd.locate(5,10);
    shlcd.printf("Subscribe to : ");
    shlcd.locate(5,18);
    shlcd.printf("%s", topic);
    wait(1.0f);
}

/* Show wait for data on lcd */
void showWaitData()
{
    shlcd.cls();
    shlcd.locate(40,2);
    shlcd.printf("Welcome");
    shlcd.locate(15,10);
    shlcd.printf("Pls wait for data ...");
}

/* Put on/off the light and active the speaker. (Danger 1 = Higth danger, Danger 3 = Low danger) */
void danger1()
{
    for (float i=2000.0; i<(float)10000.0; i+=(float)50.0) {
        speaker.period((float)1.0/i);
        speaker = 0.06;
        ledR = ledR ? 0 : 1;
        if (red.read() == 0)
            red.write(1.0f);
        else
            red.write(0.0f);
        wait(0.03);
    }
    speaker=0.0;
    ledR = 0;
    red.write(0.0f);
}

/* Put on/off the light and active the speaker. (Danger 1 = Higth danger, Danger 3 = Low danger) */
void danger2()
{
    for (float i=2000.0; i<(float)10000.0; i+=(float)75.0) {
        speaker.period((float)1.0/i);
        speaker = 0.06;
        ledR = ledR ? 0 : 1;
        if (green.read() == 0)
            green.write(1.0f);
        else
            green.write(0.0f);
        if (red.read() == 0)
            red.write(1.0f);
        else
            red.write(0.0f);
        wait(0.03);
    }
    speaker=0.0;
    ledG = 0;
    ledR = 0;
    red.write(0.0f);
    green.write(0.0f);
} 

/* Put on/off the light and active the speaker. (Danger 1 = Higth danger, Danger 3 = Low danger) */
void danger3()
{
    for (float i=2000.0; i<(float)10000.0; i+=(float)100.0) {
        speaker.period((float)1.0/i);
        speaker = 0.06;
        ledG = ledG ? 0 : 1;
        if (green.read() == 0)
            green.write(1.0f);
        else
            green.write(0.0f);
        wait(0.03);
    }
    speaker=0.0;
    ledG = 0;
    green.write(0.0f);
} 

/* Get msg from mqtt server, parse the json, show data on lcd and call the function danger. */
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    picojson::value res;
    string json((char*)message.payload);
    const char *value = json.c_str();
    
    picojson::parse(res, value, value + strlen(value));
    if (Check == (10 * (int)res.get("nb").get<double>())) {
        ledOff();
        return ;
    }
    shlcd.cls();
    shlcd.locate(-4,0);
    shlcd.printf("%s", res.get("l").get<string>().c_str());
    shlcd.locate(0,8);
    shlcd.printf("%s", res.get("t").get<string>().c_str());
    shlcd.locate(0,16);
    shlcd.printf("Distance: %s, M: %s", res.get("di").get<string>().c_str(), res.get("m").get<string>().c_str()); 
    ledOff();
    if ((int)res.get("da").get<double>() == 1)
        danger1();
    else if ((int)res.get("da").get<double>() == 2)
        danger2();
    else
        danger3();
    Check = 10 * (int)res.get("nb").get<double>();
}


int main()
{
    char *topic = "ab981_a5_iot";
    char *hostname = "test.mosquitto.org";
    int port = 1883;

    host.baud (38400);                              /* set baud rate */
    ledOff();
    showHostPort(hostname, port);
    MQTTEthernet ipstack = MQTTEthernet();
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    if (ipstack.connect(hostname, port) != 0)  /* Connecting to server */
        showErrorMsg(1);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-a5";
    data.keepAliveInterval = 20;
    data.cleansession = 1;     
    if (client.connect(data) != 0)     /* send data client */
        showErrorMsg(2);
    showSubscribe(topic);
    if (client.subscribe(topic, MQTT::QOS2, messageArrived) != 0)  /* subscribe to channel */
        showErrorMsg(3);
    showWaitData();
    while (!select || err != 1) {
        client.yield(100);
    }
    shlcd.cls();
    shlcd.locate(40,8);
    shlcd.printf("Goodbye");
    client.unsubscribe(topic);
    client.disconnect();
    ipstack.disconnect();
}