#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"
#include "FXOS8700Q.h"

#ifndef PI
#define PI           3.14159265358979323846
#endif

// Cycles between 4 modes:
//      Thermometer
//      Spirit Level
//      Compass
//      Etch a Sketch
// Move the joystick left or right to select a mode

C12832 shld_lcd (D11, D13, D12, D7, D10);

LM75B lm_temp (D14, D15);
MotionSensorDataUnits acc_data;
MotionSensorDataUnits mag_data;
FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board
FXOS8700Q_mag mag( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board
InterruptIn left(A4);
InterruptIn right(A5); 

AnalogIn pot1(A0);
AnalogIn pot2(A1);

DigitalOut red_led(LED1);
DigitalOut blue_led(LED2);
DigitalOut green_led(LED3);

static volatile int mode = 0;
int modes = 4;

void left_interrupt(void) {
        mode--;
        if(mode < 0) {
            mode = 0;   
        }
}

void right_interrupt(void) {
    mode++;
    if(mode >= modes) {
        mode = modes - 1;
    }   
}

int main()
{
    float x = 0, y = 0;
    left.mode (PullUp);
    left.fall (&left_interrupt);
    
    right.mode (PullUp);
    right.fall (&right_interrupt);
    acc.enable();
    for(;;) {
        if(mode == 0) {
            shld_lcd.cls();
            shld_lcd.locate(1, 1);
            shld_lcd.printf("Mode: Temperature");
            shld_lcd.locate(1, 22);
            int initialT = floor(lm_temp.read());
            int lowerT = initialT - 4;
            int upperT = initialT + 4;
            shld_lcd.printf("%i", lowerT);
            shld_lcd.locate(115, 22);
            shld_lcd.printf("%i", upperT);
            while(mode == 0) {
                wait(0.05);
                // Temperature Mode
                
                // temp range 26 - 30
                float t = lm_temp.read ();
                int t_int = floor(t);
                if(t < lowerT) {
                    t = lowerT;    
                } else if(t > upperT) {
                    t = upperT;   
                }
                shld_lcd.locate (40, 22);
                shld_lcd.printf("Temp: %.2f", t);
                for(int i = 0; i <= 128; i ++) {
                    int r = i / 16 + (lowerT + 0.1);
                    if(r < t) {
                        shld_lcd.line (i, 10, i, 20, 1);
                    } else {
                        shld_lcd.line (i, 10, i, 20, 0);
                    } 
                } 
            }
        } 
        else if(mode == 1) {
            while(mode == 1) {
                wait(0.05);
                acc.getAxis(acc_data);
                shld_lcd.cls();
                shld_lcd.locate(1, 1);
                shld_lcd.printf("Mode: Spirit Level");  
                x = (x + acc_data.x * 32)/2;
                y = (y -(acc_data.y * 16))/2;
                shld_lcd.fillcircle(x+63, y+15, 3, 1); //draw bubble
                shld_lcd.circle(63, 15, 8, 1); 
            }
        }
        else if(mode == 2) {
            while(mode == 2) {
                wait(0.25);
                mag.getAxis(mag_data);
                shld_lcd.cls();
                shld_lcd.locate(1, 1);
                shld_lcd.printf("Mode: Compass");  
                shld_lcd.locate(1, 10);
                double heading = atan2(mag_data.y, mag_data.x);
                if(heading < 0)
                    heading += 2*PI;
                if(heading > 2*PI)
                    heading -= 2*PI;
                heading = heading * 180 / PI;
                shld_lcd.printf("Heading %1.2f", heading);
                //shld_lcd.printf("X: %1.2f Y: %1.2f", mag_data.x, mag_data.y);
                 
            }   
        }
        else if(mode == 3) {
            int p1, p2;
            shld_lcd.locate(1,1);
            shld_lcd.printf("Mode: Etch-A-Sketch");   
            shld_lcd.locate(1,10);
            shld_lcd.printf("Use potentiometers to draw.");
            wait(2);
            shld_lcd.cls();
            while(mode == 3) {
                float p1 = (float)pot1;
                float p2 = (float)pot2;
                int x = floor((p1 * 127) + 0.5);
                int y = floor((p2 * 32) + 0.5);
                shld_lcd.pixel(x, y, 1);
                shld_lcd.copy_to_lcd();
                wait(.001);
            }
        }
    }
}