/**
 * (C) Simon Cooksey, 2015
 * 
 *  Class 03, Task 1B -- XBee Remote Sender
 *  MIT
 */

#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h" /* for the accelerometer */

MMA7660 MMA(D14, D15);              /* accelerometer */
Serial xbee(D1, D0);                /* xbee */
C12832 lcd(D11, D13, D12, D7, D10); /* lcd display*/

// Based on Colin Johnson's code available at 
// https://developer.mbed.org/users/colingj/code/lecture2_demo2/
int main(void)
{
    float x,y;
    int countdown = 0;
    
    lcd.locate(0,0);
    lcd.printf("Remote");
    
    while (1) {
        x = MMA.x();
        y = MMA.y();
        if (y>0.6f) { 
            xbee.putc('d'); 
        }
        if (y<-0.6f) { 
            xbee.putc('u');
        }
        if ((abs(x)>0.6f)&&(countdown<=0.0f)) {
            xbee.putc('p');
            countdown = 10;
        }
        countdown--;
        wait (0.1);
    }
}