/**
 * (C) Simon Cooksey, 2015
 * 
 *  Class 03, Task 1B -- XBee Remote Sender
 *  MIT
 */
 
#include "mbed.h"

#include "C12832.h"
#include "USBKeyboard.h"

Serial xbee(D1, D0);
USBKeyboard keyboard;
C12832 lcd(D11, D13, D12, D7, D10);

int main()
{
    lcd.locate(0,0);
    lcd.printf("Keyboard");
    
    while(1)
    {
        if(xbee.readable())
        {
            char command = xbee.getc();
            switch(command)
            {
                case 'u':
                    keyboard.mediaControl(KEY_VOLUME_UP);
                    break;
                case 'd':
                    keyboard.mediaControl(KEY_VOLUME_DOWN);
                    break;    
                case 'p':
                    keyboard.mediaControl(KEY_PLAY_PAUSE);
                    break;    
                default: 
                    break;
            }    
        }    
    }    
}