#include "mbed.h"
#include "C12832.h"
#include <string>

using namespace std;

/*
 * Outputs
 */
C12832 lcd(D11, D13, D12, D7, D10);
Serial host (USBTX, USBRX);
PwmOut speaker(D6);

InterruptIn sw3(PTA4);
InterruptIn sw2(PTC6);

volatile int bufferInsert = 0;
volatile int currentBufferSize = 0;
const int bufferSize = 512;
char rxBuffer[bufferSize];
//Ascii code for "-", it is used to end messages
const char dash = 45;

void rxInterrupt(void){
    //Reads all available data from the serial into the buffer as long as the buffer is not full       
    while ((host.readable()) && (currentBufferSize != bufferSize)){
        rxBuffer[bufferInsert] = host.getc();
        bufferInsert = (bufferInsert + 1) % bufferSize;
        currentBufferSize++;
    }
    int index = (bufferInsert - currentBufferSize) % bufferSize;
    string message = "";
    //Looks for a message in buffer
    while (index != bufferInsert){
        if(rxBuffer[index] == dash){
            //everything between (bufferInsert - currentBufferSize) and index is the message
            //Removes the message from the buffer
            while(((bufferInsert - currentBufferSize) % bufferSize) != index){
                message.append(string(1, rxBuffer[((bufferInsert - currentBufferSize) % bufferSize)]));
                currentBufferSize--;
            }
            //The last character will be "-", so it removes it from the buffer
            currentBufferSize--;                
            break;
        }
        index = (index + 1) % bufferSize;
    }
    if(message == "jordan page" || message == "arez page"){
        lcd.cls();
        lcd.locate(0,10);
        lcd.printf("%sd you", message.c_str());
        for (float i=2000.0f; i<10000.0f; i+=100) {
            speaker.period(1.0f/i);
            speaker=0.5;
            wait(0.02);
        }
        speaker=0.0;
    }
}

void sw3interrupt(void){
    host.printf("niklas page-");
}

void sw2interrupt(void){
    lcd.cls();    
}

int main(void){
    host.baud(38400);
    
    sw3.mode(PullUp);
    sw3.fall(&sw3interrupt);
    
    sw2.mode(PullUp);
    sw2.fall(&sw2interrupt);
    
    host.attach(&rxInterrupt, Serial::RxIrq);
    
    for(;;){
        wait(0.1);
    }
}